% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvar-methods.R
\name{stability}
\alias{stability}
\alias{stability.pvargmm}
\alias{print.pvarstability}
\alias{plot.pvarstability}
\title{Stability of PVAR(p) model}
\usage{
stability(model, ...)

\method{stability}{pvargmm}(model, ...)

\method{print}{pvarstability}(x, ...)

\method{plot}{pvarstability}(x, ...)
}
\arguments{
\item{model}{PVAR model}

\item{...}{Further arguments}

\item{x}{A \code{pvarstability} object required for corresponding \code{print} and \code{plot} methods}
}
\value{
A \code{pvarstability} object containing eigenvalue stability conditions
}
\description{
Stability of PVAR(p) model
}
\section{Methods (by class)}{
\itemize{
\item \code{pvarstability}: S3 print method for pvarstability object

\item \code{pvarstability}: S3 plot method for pvarstability object, returns a \code{ggplot} object
}}

\examples{
data("ex1_dahlberg_data")
stability_info <- stability(ex1_dahlberg_data)
print(stability_info)
plot(stability_info)
}
