% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_beeplot.R
\name{apa_beeplot}
\alias{apa_beeplot}
\alias{apa_beeplot.default}
\alias{apa_beeplot.afex_aov}
\title{Bee-swarm Plots for Factorial Designs that Conform to APA Guidelines}
\usage{
apa_beeplot(data, ...)

\method{apa_beeplot}{default}(
  data,
  id,
  factors = NULL,
  dv,
  tendency = mean,
  dispersion = conf_int,
  level = 0.95,
  fun_aggregate = mean,
  na.rm = TRUE,
  use = "all.obs",
  intercept = NULL,
  args_x_axis = NULL,
  args_y_axis = NULL,
  args_title = NULL,
  args_points = NULL,
  args_swarm = NULL,
  args_error_bars = NULL,
  args_legend = NULL,
  jit = 0.3,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ...
)

\method{apa_beeplot}{afex_aov}(
  data,
  tendency = mean,
  dispersion = conf_int,
  fun_aggregate = mean,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} that contains the data, or an object of class \code{afex_aov}.}

\item{...}{
  Arguments passed on to \code{\link[=apa_factorial_plot]{apa_factorial_plot}}
  \describe{
    \item{\code{}}{}
  }}

\item{id}{Character. Variable name that identifies subjects.}

\item{factors}{Character. A vector of up to four variable names that is used to stratify the data.}

\item{dv}{Character. The name of the dependent variable.}

\item{tendency}{Closure. A function that will be used as measure of central tendency.}

\item{dispersion}{Closure. A function that will be used to construct error bars (i.e., whiskers). Defaults to
\code{\link[=conf_int]{conf_int()}} for 95\% between-subjects confidence intervals. See details for more options, especially for within-subjects confidence intervals.}

\item{level}{Numeric. Defines the width of the interval if confidence intervals are plotted. Defaults to \code{0.95}.
for 95\% confidence intervals. Ignored if \code{dispersion} is not a confidence-interval function. See details.}

\item{fun_aggregate}{Closure. The function that will be used to aggregate observations within subjects and factors
before calculating descriptive statistics for each cell of the design. Defaults to \code{mean}.}

\item{na.rm}{Logical. Specifies if missing values are removed. Defaults to \code{TRUE}.}

\item{use}{Character. Specifies a method to exclude cases if there are missing values \emph{after} aggregating.
Possible options are \code{"all.obs"} or \code{"complete.obs"}.}

\item{intercept}{Numeric. Adds a horizontal line at height \code{intercept} to the plot. Can be either a single value or a matrix. For the matrix
case, multiple lines are drawn, where the dimensions of the matrix determine the number of lines to be drawn.}

\item{args_x_axis}{An optional \code{list} that contains further arguments that may be passed to \code{\link[=axis]{axis()}} for customizing the \emph{x} axis.}

\item{args_y_axis}{An optional \code{list} that contains further arguments that may be passed to \code{\link[=axis]{axis()}} for customizing the \emph{y} axis.}

\item{args_title}{An optional \code{list} that contains further arguments that may be passed to \code{\link[=title]{title()}}.}

\item{args_points}{An optional \code{list} that contains further arguments that may be passed to \code{\link[=points]{points()}}.}

\item{args_swarm}{An optional \code{list} that contains further arguments to customize the \code{\link[=points]{points()}} of the beeswarm.}

\item{args_error_bars}{An optional \code{list} that contains further arguments that may be passed to \code{\link[=arrows]{arrows()}}.}

\item{args_legend}{An optional \code{list} that contains further arguments that may be passed to \code{\link[=legend]{legend()}}}

\item{jit}{Numeric. Determines the amount of horizontal displacement. Defaults to \code{0.3}, defaults to \code{0.4} if \code{plot = "bars"}.}

\item{xlab}{Character or expression. Label for \emph{x} axis.}

\item{ylab}{Character or expression. Label for \emph{y} axis.}

\item{main}{Character or expression. For up to two factors, simply specify the main title. If you stratify the data by more than two factors,
either specify a single value that will be added to automatically generated main title, \emph{or} specify an array of multiple titles, one for each plot area.}
}
\value{
A named (nested) list of plot options including raw and derived data. \emph{Note that the structure of the return value is about to change in a forthcoming release of papaja.}
}
\description{
Create one or more beeswarm plots from a \code{data.frame} containing data from
a factorial design and set APA-friendly defaults.
}
\details{
The measure of dispersion can be either \code{\link[=conf_int]{conf_int()}} for between-subjects confidence intervals, \code{\link[=se]{se()}} for standard errors,
or any other standard function. For within-subjects confidence intervals, specify \code{\link[=wsci]{wsci()}} or \code{\link[=within_subjects_conf_int]{within_subjects_conf_int()}}.

If between- or within-subjects confidence intervals are requested, you can also specify the area of the cumulative
distribution function that will be covered. For instance, if you want a 98\% confidence interval, specify
\code{level = 0.98}. The default is \code{level = 0.95} for 95\% confidence intervals.
\subsection{Customization of plot elements}{

\code{\link[=apa_factorial_plot]{apa_factorial_plot()}} and its descendants \code{\link[=apa_barplot]{apa_barplot()}}, \code{\link[=apa_lineplot]{apa_lineplot()}},
and \code{\link[=apa_beeplot]{apa_beeplot()}} are wrapper functions that sequentially call:
\itemize{
\item \code{\link[=plot.new]{plot.new()}},
\item \code{\link[=plot.window]{plot.window()}},
\item \code{\link[=axis]{axis()}} (once for \emph{x} axis, once for \emph{y} axis),
\item \code{\link[=title]{title()}} for axis labels and titles,
\item \code{\link[=rect]{rect()}} for bars in bar plots,
\item \code{\link[=points]{points()}} for bee swarms,
\item \code{\link[=lines]{lines()}} for lines connecting central tendency points,
\item \code{\link[=arrows]{arrows()}} for error bars,
\item \code{\link[=points]{points()}} for tendency points,
\item \code{\link[=legend]{legend()}} for a legend, and
\item \code{\link[=lines]{lines()}} for intercepts.
}

These calls can be customized by setting the respective parameters \verb{args_*** = list(...)}.
}
}
\examples{
apa_beeplot(
   data = npk
   , id = "block"
   , dv = "yield"
   , factors = c("N")
)

apa_beeplot(
  data = npk
 , id = "block"
 , dv = "yield"
 , factors = c("N", "P")
 , args.legend = list(x = "center")
)

apa_beeplot(
   data = npk
   , id = "block"
   , dv = "yield"
   , factors = c("N", "P", "K")
   , ylim = c(0, 80)
   , level = .34
   , las = 1
)

}
\seealso{
Other plots for factorial designs: 
\code{\link{apa_barplot}()},
\code{\link{apa_factorial_plot}()},
\code{\link{apa_lineplot}()}
}
\concept{plots for factorial designs}
