% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeroc_fit.R
\name{timeroc_fit}
\alias{timeroc_fit}
\title{timeroc_fit}
\usage{
timeroc_fit(
  obj,
  x,
  t,
  event,
  init.param.x = NULL,
  init.param.t = NULL,
  init.param.copula = NULL,
  init.param.ph = NULL,
  ci = 0.95,
  method = "mle",
  weights = NULL,
  breakpoints = NULL,
  init_bayes = NULL
)
}
\arguments{
\item{obj}{An initialized 'TimeROC' object.\cr}

\item{x}{A numeric vector of single biomarker or covariate.\cr}

\item{t}{A numeric vector of time-to-event.\cr}

\item{event}{A numeric vector of event status (0=dead, 1=alive).\cr}

\item{init.param.x}{Vector of starting value for biomarker parameter.\cr}

\item{init.param.t}{Vector of starting value for time-to-event parameter.\cr}

\item{init.param.copula}{An integer of starting value for copula parameter.\cr}

\item{init.param.ph}{An integer of starting value for association parameter.\cr}

\item{ci}{An integer 0 to 1 for confidence level.\cr}

\item{method}{A string specifying method of estimation. (Default = 'mle') \cr}

\item{weights}{Weights to handle Inverse Probability Censoring Weights. \cr}

\item{breakpoints}{Break points to specify intervals for Piecewise Hazard Model. \cr}

\item{init_bayes}{Starting value when running the bayesian estimation.\cr}
}
\value{
return a list of frequentist or bayesian estimator.
}
\description{
Fit TimeROC using Maximum Likelihood Estimator.
}
\examples{
\dontrun{
## fitting copula model
test <- timeroc_obj(dist = 'gompertz-gompertz-copula', copula = "gumbel90")
set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0, n=500,
               params.t = c(shape=3,rate=1),
               params.x = c(shape=1,rate=2),
               params.copula=-5) # name of parameter must follow standard

plot(t~x, rr)
start.t <- Sys.time()
cc <- timeroc_fit(rr$x, rr$t, rr$event, obj = test)
print(Sys.time()-start.t)

## fitting PH model
test <- timeroc_obj(dist = 'weibull-lognormal-PH')
set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0, n=100,
               params.t = c(meanlog=0, sdlog=1),
               params.x = c(shape=2, scale=1),
               params.ph=0.5) # name of parameter must follow standard
plot(t~x, rr)
start.t <- Sys.time()
cc <- timeroc_fit(rr$x, rr$t, rr$event, obj = test)
print(Sys.time()-start.t)
}
}
