% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProgressDecorator.R
\name{ProgressDecorator}
\alias{ProgressDecorator}
\title{ProgressDecorator}
\description{
This class represents a progress tracking context for interacting with
\code{\link{Backend}} implementations via the \code{\link{Service}} interface.
}
\details{
This class extends the base \code{\link{Context}} class and overrides the
\code{\link[=Context]{sapply}} parent method to decorate the backend instance
with additional functionality. Specifically, this class creates a temporary
file to log the progress of backend tasks, and then creates a progress bar to
display the progress of the backend tasks.

The progress bar is updated after each backend task execution. The timeout
between subsequent checks of the temporary log file is controlled by the
\code{\link{Options}} class and defaults to \code{0.001}. This value can be
adjusted via the \code{\link{Options}} instance present in the session
\code{\link[base:options]{base::.Options}} list (i.e., see \code{\link[=set_option]{set_option()}}). For example, to
set the timeout to \code{0.1} we can run \code{set_option("progress_timeout", 0.1)}.

This class is a good example of how to extend the base \code{\link{Context}}
class to decorate the backend instance with additional functionality.
}
\examples{
# Define a task to run in parallel.
task <- function(x, y) {
    # Sleep a bit.
    Sys.sleep(0.15)

    # Return the result of a computation.
    return(x + y)
}

# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 2)

# Set the cluster type.
specification$set_type(type = "psock")

# Create a backend factory.
backend_factory <- BackendFactory$new()

# Get a backend instance that does not support progress tracking.
backend <- backend_factory$get("sync")

# Create a progress tracking context object.
context <- ProgressDecorator$new()

# Attempt to set the incompatible backend instance.
\dontrun{context$set_backend(backend)}

# Get a backend instance that does support progress tracking.
backend <- backend_factory$get("async")

# Register the backend with the context.
context$set_backend(backend)

# From now all, all backend operations are intercepted by the context.

# Start the backend.
context$start(specification)

# Create a bar factory.
bar_factory <- BarFactory$new()

# Get a modern bar instance.
bar <- bar_factory$get("modern")

# Register the bar with the context.
context$set_bar(bar)

# Configure the bar.
context$configure_bar(
    show_after = 0,
    format = " > completed :current out of :total tasks [:percent] [:elapsed]"
)

# Run a task in parallel (i.e., approx. 1.9 seconds).
context$sapply(x = 1:25, fun = task, y = 10)

# Get the task output.
backend$get_output(wait = TRUE)

# Change the bar type.
bar <- bar_factory$get("basic")

# Register the bar with the context.
context$set_bar(bar)

# Remove the previous bar configuration.
context$configure_bar()

# Run a task in parallel (i.e., approx. 1.9 seconds).
context$sapply(x = 1:25, fun = task, y = 10)

# Get the task output.
backend$get_output(wait = TRUE)

# Close the backend.
context$stop()

}
\seealso{
\code{\link{Context}}, \code{\link{Service}}, \code{\link{Backend}}, and
\code{\link{AsyncBackend}}.
}
\section{Super class}{
\code{\link[parabar:Context]{parabar::Context}} -> \code{ProgressDecorator}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{bar}}{The \code{\link{Bar}} instance registered with the context.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ProgressDecorator-set_backend}{\code{ProgressDecorator$set_backend()}}
\item \href{#method-ProgressDecorator-set_bar}{\code{ProgressDecorator$set_bar()}}
\item \href{#method-ProgressDecorator-configure_bar}{\code{ProgressDecorator$configure_bar()}}
\item \href{#method-ProgressDecorator-sapply}{\code{ProgressDecorator$sapply()}}
\item \href{#method-ProgressDecorator-clone}{\code{ProgressDecorator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="clear"><a href='../../parabar/html/Context.html#method-Context-clear'><code>parabar::Context$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="evaluate"><a href='../../parabar/html/Context.html#method-Context-evaluate'><code>parabar::Context$evaluate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="export"><a href='../../parabar/html/Context.html#method-Context-export'><code>parabar::Context$export()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="get_output"><a href='../../parabar/html/Context.html#method-Context-get_output'><code>parabar::Context$get_output()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="peek"><a href='../../parabar/html/Context.html#method-Context-peek'><code>parabar::Context$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="start"><a href='../../parabar/html/Context.html#method-Context-start'><code>parabar::Context$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="stop"><a href='../../parabar/html/Context.html#method-Context-stop'><code>parabar::Context$stop()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressDecorator-set_backend"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressDecorator-set_backend}{}}}
\subsection{Method \code{set_backend()}}{
Set the backend instance to be used by the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressDecorator$set_backend(backend)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{An object of class \code{\link{Backend}} that supports
progress tracking implements the \code{\link{Service}} interface.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method overrides the parent method to validate the backend
provided and guarantee it is an instance of the
\code{\link{AsyncBackend}} class.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressDecorator-set_bar"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressDecorator-set_bar}{}}}
\subsection{Method \code{set_bar()}}{
Set the \code{\link{Bar}} instance to be used by the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressDecorator$set_bar(bar)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bar}}{An object of class \code{\link{Bar}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressDecorator-configure_bar"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressDecorator-configure_bar}{}}}
\subsection{Method \code{configure_bar()}}{
Configure the \code{\link{Bar}} instance registered with the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressDecorator$configure_bar(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{A list of named arguments passed to the \code{create()} method
of the \code{\link{Bar}} instance. See the documentation of the
specific concrete bar for details (e.g., \code{\link{ModernBar}}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressDecorator-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressDecorator-sapply}{}}}
\subsection{Method \code{sapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}, but with a
progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressDecorator$sapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector (i.e., usually of integers) to pass to the \code{fun}
function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressDecorator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressDecorator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressDecorator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
