% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{flipLoadings}
\alias{flipLoadings}
\title{Sign flip the loadings of many randomly initialized models to make consistent overview plots.}
\usage{
flipLoadings(models, X)
}
\arguments{
\item{models}{Output of \link{parafac}.}

\item{X}{Input dataset of parafac modelling procedure.}
}
\value{
models with sign flipped components where applicable.
}
\description{
Sign flip the loadings of many randomly initialized models to make consistent overview plots.
}
\examples{
A = array(rnorm(108*2), c(108,2))
B = array(rnorm(100*2), c(100,2))
C = array(rnorm(10*2), c(10,2))
X = reinflateTensor(A, B, C)
models = parafac(X, 2, nstart=10, output="all", sortComponents=TRUE)
flippedModels = flipLoadings(models, X)
}
