% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{getValue}
\alias{getValue}
\title{Plot attributes}
\usage{
getValue(id, attrType, valueInputId)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{attrType}{which value is requested.}

\item{valueInputId}{reactive input to write to.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Asks to retrieve the value of an attribute.
}
\details{
Available attributes are 'Cutoffs', 'SelectedTraces' and 'ReferenceColumn'.
Result will be sent through a reactive input.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       actionButton("getSelectedTracesAction", "Retrieve Selected Traces"),
       p("The button displays the list of uncutted rows (use brush to reduce it)"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(iris)
       })
       observeEvent(input$getSelectedTracesAction, {
           attributeType <- "SelectedTraces"
           parallelPlot::getValue("parPlot", attributeType, "MySelectedTraces")
       })
       observeEvent(input$MySelectedTraces, {
           showModal(modalDialog(
               title = "Selected Traces",
               toString(input$MySelectedTraces)
           ))
       })
   }

   shinyApp(ui, server)
 }

}
