% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setArrangeMethod}
\alias{setArrangeMethod}
\title{Lines position}
\usage{
setArrangeMethod(id, arrangeMethod)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{arrangeMethod}{One of the available arrange methods ("fromLeft", "fromRight", "fromBoth", "fromNone").}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Within a category box:
  the position of lines can be calculated to minimize crossings on the left of the box (\code{fromLeft});
  the position of lines can be calculated to minimize crossings on the right (\code{fromRight}, default behavior);
  lines can be split in two points to minimize crossings on the left and on the right (\code{fromBoth}).
  To turn this ordering off (for example for performance reasons),
  `arrangeMethod` can also be set to \code{fromNone}.
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       selectInput(
         "arrangeMethodSelect",
         "Arrange Method:",
         choices = list(
           "fromLeft" = "fromLeft", "fromRight" = "fromRight",
           "fromBoth" = "fromBoth", "fromNone" = "fromNone"
         ),
         selected = "fromRight"
       ),
       p("The selector controls the method used to arrange lines position in category boxes"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           categorical <- list(
               NULL, c(4, 6, 8), NULL, NULL, NULL, NULL, NULL, c(0, 1), c(0, 1), 3:5, 1:8
           )
           parallelPlot(mtcars, categorical = categorical, refColumnDim = "cyl")
       })
       observeEvent(input$arrangeMethodSelect, {
           parallelPlot::setArrangeMethod("parPlot", input$arrangeMethodSelect)
       })
   }

   shinyApp(ui, server)
 }

}
