% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_error.R
\name{reporter}
\alias{reporter}
\title{Turn a parser into an error reporting parser}
\usage{
reporter(p)
}
\arguments{
\item{p}{a parser.}
}
\value{
The \code{L}-part of a successful parser result or an error message about
the line where the parser failed. A warning is thrown when the parser
did not completely consume the input.
}
\description{
Turns a parser into an error reporting parser, and when the parser is
successful returns only the \code{L}-element of the parser output, the
successfully parsed part of the input (see \code{\link[=succeed]{succeed()}}).
}
\details{
The error object that this function returns is a list containing the
elements \code{linenr} and \code{linecontent}, corresponding to the line in which the
parser failed and its content. The user of this package can catch this
object to create custom error messages instead of the message generated by
this function.

A warning is issued when the parser did not completely consume the input.
Complete consumption of input is only explicitly made when the parser ends
with \code{\link[=eof]{eof()}}. Therefore, even though all elements were parsed, a zero-length
character vector will remain in the \code{R} element if the parser does not end
with \code{\link[=eof]{eof()}}.
}
\examples{
at <- function() literal("a") \%then\% literal("t")
atat <- rep(c("a","t"),2)
# Yields an error message about parser failing on line 5
try(
  reporter(match_n(3,at()) \%then\% eof())(c(atat,"t","t"))
)
# No error, but parser result
reporter(match_n(2,at()) \%then\% eof())(atat)
# warning: the input is not completely consumed
try(
  reporter(match_n(2,at()))(atat)
)

}
