% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{store}
\alias{store}
\alias{retrieve}
\title{Store and retrieve objects}
\usage{
store(name, value)

retrieve(name)
}
\arguments{
\item{name}{a string used as the name of the stored object.}

\item{value}{object to be stored.}
}
\value{
Nothing for \code{store()} and the stored object for \code{retrieve()}.
}
\description{
Sometimes you want to use a parsed object to modify a later parser operation,
as in the example below. The \code{store()} and \code{retrieve()} functions provide the
tools to create such a parser.
}
\examples{
parse_nr <- function(line) {
  m <- stringr::str_extract(line, "number=(\\\\d+)", group = 1)
  if (is.na(m)) {
    list()
  } else {
    store("nr", as.numeric(m))
  }
}

p <- function() {
  match_s(parse_nr) \%then\%
    exactly(retrieve("nr"), literal("A"))
}

p()(c("number=3", "A", "A", "A")) # success
p()(c("number=2", "A", "A", "A")) # failure
}
