% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parglm.R
\name{parglm}
\alias{parglm}
\alias{parglm.fit}
\title{Fitting Generalized Linear Models in Parallel}
\usage{
parglm(formula, family = gaussian, data, weights, subset, na.action,
  start = NULL, offset, control = list(...), contrasts = NULL,
  model = TRUE, x = FALSE, y = TRUE, ...)

parglm.fit(x, y, weights = rep(1, nobs), start = NULL,
  etastart = NULL, mustart = NULL, offset = rep(0, nobs),
  family = gaussian(), control = list(), intercept = TRUE, ...)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}}.}

\item{family}{a \code{\link{family}} object.}

\item{data}{an optional data frame, list or environment containing the variables
in the model.}

\item{weights}{an optional vector of 'prior weights' to be used in the fitting process. Should
be \code{NULL} or a numeric vector.}

\item{subset}{an optional vector specifying a subset of observations to be used in
the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain \code{NA}s.}

\item{start}{starting values for the parameters in the linear predictor.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting.}

\item{control}{a list of parameters for controlling the fitting process.
For parglm.fit this is passed to \code{\link{parglm.control}}.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of
\code{\link{model.matrix.default}}.}

\item{model}{a logical value indicating whether model frame should be included
as a component of the returned value.}

\item{x, y}{For \code{parglm}: logical values indicating whether the response vector
and model matrix used in the fitting process should be returned as components of the
returned value.

For \code{parglm.fit}: \code{x} is a design matrix of dimension \code{n * p}, and
\code{y} is a vector of observations of length \code{n}.}

\item{...}{For \code{parglm}: arguments to be used to form the default \code{control} argument
if it is not supplied directly.

For \code{parglm.fit}: unused.}

\item{etastart}{starting values for the linear predictor. Not supported.}

\item{mustart}{starting values for the vector of means. Not supported.}

\item{intercept}{logical. Should an intercept be included in the null model?}
}
\value{
\code{glm} object as returned by \code{\link{glm}} but differs mainly by the \code{qr}
element. The \code{qr} element in the object returned by \code{parglm}(\code{.fit}) only has the \eqn{R}
matrix from the QR decomposition.
}
\description{
Function like \code{\link{glm}} which can make the computation
in parallel. The function supports most families listed in \code{\link{family}}.
See "\code{vignette("parglm", "parglm")}" for run time examples.
}
\examples{
# small example from `help('glm')`. Fitting this model in parallel does
# not matter as the data set is small
clotting <- data.frame(
  u = c(5,10,15,20,30,40,60,80,100),
  lot1 = c(118,58,42,35,27,25,21,19,18),
  lot2 = c(69,35,26,21,18,16,13,12,12))
f1 <- glm   (lot1 ~ log(u), data = clotting, family = Gamma)
f2 <- parglm(lot1 ~ log(u), data = clotting, family = Gamma,
             control = parglm.control(nthreads = 2L))
all.equal(coef(f1), coef(f2))

}
