% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_peptides.R
\name{map_peptides}
\alias{map_peptides}
\title{Map peptides to their locations within a protein}
\usage{
map_peptides(msf_file, min_conf = "High", prot_regex = "")
}
\arguments{
\item{msf_file}{A file path to a Thermo MSF file.}

\item{min_conf}{"High", "Medium", or "Low". The mininum peptide confidence level to retrieve from MSF file.}

\item{prot_regex}{Regular expression where the first group matches a protein name or ID from the protein description. Regex must contain ONE group. The protein description is typically generated from a fasta reference file that was used for the database search.}
}
\value{
A dataframe containing start and stop positions (relative to the parent protein sequence) for each peptide in the database.

\item{peptide_id}{a unique peptide ID}
\item{spectrum_id}{a unique spectrum ID}
\item{protein_id}{unique protein group ID to which this peptide maps}
\item{protein_desc}{protein description from reference database used to assign peptides to protein groups, parsed according to \code{prot_regex}}
\item{peptide_sequence}{amino acid sequence (does not show post-translational modifications)}
\item{pep_score}{PEP score}
\item{q_value}{Q-value score}
\item{protein_sequence}{parent protein sequence}
\item{start}{start position of peptide within protein sequence}
\item{end}{end position of peptide within protein sequence}
}
\description{
Takes a Thermo MSF file and finds the location of each peptide within its corresponding protein sequence. In cases where a single peptide maps to multiple locations within a protein sequence, only the first location is reported.
}
\examples{
map_peptides(parsemsf_example("test_db.msf"))
}

