% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/children.R, R/firstborn.R, R/parent.R,
%   R/siblings.R
\name{family-nodes}
\alias{family-nodes}
\alias{pd_get_children_ids}
\alias{pd_is_firstborn}
\alias{pd_get_firstborn}
\alias{pd_get_parent_id}
\alias{pd_get_ancestor_ids}
\alias{pd_get_sibling_ids}
\alias{pd_get_next_sibling_id}
\alias{pd_get_prev_sibling_id}
\title{Family-wise Node Identification and Navigation.}
\usage{
pd_get_children_ids(id, pd, ngenerations = 1, include.self = FALSE,
  aggregate = TRUE, .check = TRUE)

pd_is_firstborn(id, pd, .check = TRUE)

pd_get_firstborn(id, pd, .check = TRUE)

pd_get_parent_id(id, pd, .check = TRUE)

pd_get_ancestor_ids(id, pd, ngenerations = Inf, aggregate = TRUE,
  include.self = TRUE, only.present = FALSE, last = 0L,
  .check = TRUE)

pd_get_sibling_ids(id, pd, .check = TRUE)

pd_get_next_sibling_id(id, pd, .check = TRUE)

pd_get_prev_sibling_id(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{ngenerations}{Number of generations to go forwards or backwards.}

\item{include.self}{Should the root node (\code{id}) be included?}

\item{aggregate}{Should aggregate(TRUE) or only the
the final (FALSE) generation be returned?}

\item{.check}{Perform checks for input validation?}

\item{only.present}{should the list be restricted to only those
node that are present?  Most relevant for
when parent is zero.}

\item{last}{The last acceptable parent.}

\item{...}{arguments passed on.}
}
\description{
Parse data is organized into a hierarchy of nodes. These functions provide
simple ways to identify the nodes of interest, often from a specified node
of interest.

Test if an expression is the firstborn, i.e. oldest or lowest id.
}
\details{
The language parsetools uses is that of family.
Similar to a family each node could have: a \dfn{parent}, the node that contains the
node in question; \dfn{children}, the nodes contained by the given node;
\dfn{ancestors}, the collection of nodes that contain the given node, it's parent,
it's parent's parent, and so on; and \dfn{descendents}, the collection of nodes that are
contained by the given node or contained by those nodes, and so on.
Terminology is analogous, a \dfn{generation} is all the the nodes at the same depth in
the hierarchy. A node may have \dfn{siblings}, the set of nodes with the same parent.
If a node does not have a parent it is called a \dfn{root} node.

Similarly, age is also used as an analogy for ease of navigation.  Generally, nodes
are numbered by the order that they are encountered, when parsing the source.
Therefore the node with the smallest \code{id} among a set of siblings is referred to the
\dfn{firstborn}.  This is give the special designation as it is the most often of children
used, as it likely determines the type of call or expression that is represented by the node.
The firstborn has no 'older' siblings, the 'next' sibling would be the next oldest, i.e. the
node among siblings with the smallest id, but is not smaller that the reference node id.

In all cases when describing function the \code{id}, is assumed to be in the context of the
parse data object \code{pd} and for convenience refers to the node associated with said \code{id}.
}
\section{Functions}{
\itemize{
\item \code{pd_get_children_ids}: Get all nodes that are children of \code{id}.
Get all ids in \code{pd} that are children of \code{id}.
i.e. lower in the hierarchy or with id as a parent.
If \code{ngenerations} is greater than 1 and \code{aggregate}
is \code{TRUE}, all descendents are aggregated and returned.

\item \code{pd_is_firstborn}: Test if \code{id} is firstborn.

\item \code{pd_get_firstborn}: Get the firstborn child of \code{id}.

\item \code{pd_get_parent_id}: Get the parent of \code{id}.

\item \code{pd_get_ancestor_ids}: Get the ancestors of \code{id}.

\item \code{pd_get_sibling_ids}: Identify siblings of \code{id}.

\item \code{pd_get_next_sibling_id}: Get the next younger sibling.

\item \code{pd_get_prev_sibling_id}: Get the next older sibling.
}}

\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

# assignments have three children
# The operator, the assignment, and the value.
kids <- pd_get_children_ids(roots[[1]], pd)
# The token tells what kind of node the ids represent.
pd_token(kids, pd)
}
