% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comments.R
\name{pd_is_comment}
\alias{pd_is_comment}
\alias{pd_is_relative_comment}
\alias{pd_all_relative_comment_ids}
\alias{pd_is_doc_comment}
\title{Is this a comment?}
\usage{
pd_is_comment(id, pd, .check = TRUE)

pd_is_relative_comment(id, pd, .check = TRUE)

pd_all_relative_comment_ids(pd)

pd_is_doc_comment(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{.check}{Perform checks for input validation?}
}
\value{
Should return a logical vector, for parse-data and data.frame should
be length of \code{nrow(x)}.  For character same length as x.
}
\description{
\subsection{pd_is_comment}{
Test if an id represents a comment of any kind.
}

\subsection{pd_is_relative_comment}{
Tests if the comment is a relative (location dependent) type comment.
}

\subsection{pd_all_relative_comment_ids}{
Retrieve all ids associated with relative comments.
}

\subsection{pd_is_doc_comment}{
Additionally tests if the comment is a documentation type comment.
}
}
