% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mars.R
\name{mars}
\alias{mars}
\title{General Interface for MARS}
\usage{
mars(
  mode = "unknown",
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{num_terms}{The number of features that will be retained in the
final model, including the intercept.}

\item{prod_degree}{The highest possible interaction degree.}

\item{prune_method}{The pruning method.}
}
\description{
\code{mars()} is a way to generate a \emph{specification} of a model before
fitting and allows the model to be created using R. The main
arguments for the
model are:
\itemize{
\item \code{num_terms}: The number of features that will be retained in the
final model.
\item \code{prod_degree}: The highest possible degree of interaction between
features. A value of 1 indicates an additive model while a value of 2
allows, but does not guarantee, two-way interactions between features.
\item \code{prune_method}: The type of pruning. Possible values are listed
in \code{?earth}.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and arguments can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"earth"}  (the default)
}
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are below.
\subsection{earth}{\if{html}{\out{<div class="r">}}\preformatted{mars() \%>\% 
  set_engine("earth") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## MARS Model Specification (regression)
## 
## Computational engine: earth 
## 
## Model fit template:
## earth::earth(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     keepxy = TRUE)
}\if{html}{\out{<div class="r">}}\preformatted{mars() \%>\% 
  set_engine("earth") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## MARS Model Specification (classification)
## 
## Engine-Specific Arguments:
##   glm = list(family = stats::binomial)
## 
## Computational engine: earth 
## 
## Model fit template:
## earth::earth(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     glm = list(family = stats::binomial), keepxy = TRUE)
}

Note that, when the model is fit, the \code{earth} package only has its
namespace loaded. However, if \code{multi_predict} is used, the package is
attached.

Also, \code{fit()} passes the data directly to \code{earth::earth()} so that its
formula method can create dummy variables as-needed.

For this engine, tuning over \code{num_terms} is very efficient since the
same model object can be used to make predictions over multiple values
of \code{num_terms}.
}

\subsection{Parameter translations}{

The standardized parameter names in parsnip can be mapped to their
original names in each engine that has main parameters. Each engine
typically has a different default value (shown in parentheses) for each
parameter.\tabular{ll}{
   \strong{parsnip} \tab \strong{earth} \cr
   num_terms \tab nprune \cr
   prod_degree \tab degree (1) \cr
   prune_method \tab pmethod (backward) \cr
}

}
}

\examples{
show_engines("mars")

mars(mode = "regression", num_terms = 5)
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=set_engine]{set_engine()}}, \code{\link[=update]{update()}}
}
