% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullmodel.R
\name{nullmodel}
\alias{nullmodel}
\alias{nullmodel.default}
\alias{predict.nullmodel}
\alias{print.nullmodel}
\title{Fit a simple, non-informative model}
\usage{
nullmodel(x, ...)

\method{nullmodel}{default}(x = NULL, y, ...)

\method{print}{nullmodel}(x, ...)

\method{predict}{nullmodel}(object, new_data = NULL, type = NULL, ...)
}
\arguments{
\item{x}{An optional matrix or data frame of predictors. These values are
not used in the model fit}

\item{\dots}{Optional arguments (not yet used)}

\item{y}{A numeric vector (for regression) or factor (for classification) of
outcomes}

\item{object}{An object of class \code{nullmodel}}

\item{new_data}{A matrix or data frame of predictors (only used to determine
the number of predictions to return)}

\item{type}{Either "raw" (for regression), "class" or "prob" (for
classification)}
}
\value{
The output of \code{nullmodel()} is a list of class \code{nullmodel}
with elements \item{call }{the function call} \item{value }{the mean of
\code{y} or the most prevalent class} \item{levels }{when \code{y} is a
factor, a vector of levels. \code{NULL} otherwise} \item{pct }{when \code{y}
is a factor, a data frame with a column for each class (\code{NULL}
otherwise). The column for the most prevalent class has the proportion of
the training samples with that class (the other columns are zero). } \item{n
}{the number of elements in \code{y}}

\code{predict.nullmodel()} returns either a factor or numeric vector
depending on the class of \code{y}. All predictions are always the same.
}
\description{
Fit a single mean or largest class model. \code{nullmodel()} is the underlying
computational function for the \code{null_model()} specification.
}
\details{
\code{nullmodel()} emulates other model building functions, but returns the
simplest model possible given a training set: a single mean for numeric
outcomes and the most prevalent class for factor outcomes. When class
probabilities are requested, the percentage of the training set samples with
the most prevalent class is returned.
}
\examples{

outcome <- factor(sample(letters[1:2],
                         size = 100,
                         prob = c(.1, .9),
                         replace = TRUE))
useless <- nullmodel(y = outcome)
useless
predict(useless, matrix(NA, nrow = 5))

}
\keyword{internal}
\keyword{models}
