% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest.R
\name{rand_forest}
\alias{rand_forest}
\title{General Interface for Random Forest Models}
\usage{
rand_forest(mode = "unknown", mtry = NULL, trees = NULL, min_n = NULL)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{mtry}{An integer for the number of predictors that will
be randomly sampled at each split when creating the tree models.}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}
}
\description{
\code{rand_forest()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or via Spark. The main arguments for the
model are:
\itemize{
\item \code{mtry}: The number of predictors that will be
randomly sampled at each split when creating the tree models.
\item \code{trees}: The number of trees contained in the ensemble.
\item \code{min_n}: The minimum number of data points in a node
that are required for the node to be split further.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"ranger"} (the default) or \code{"randomForest"}
\item \pkg{Spark}: \code{"spark"}
}
}
\note{
For models created using the spark engine, there are
several differences to consider. First, only the formula
interface to via \code{fit()} is available; using \code{fit_xy()} will
generate an error. Second, the predictions will always be in a
spark table format. The names will be the same as documented but
without the dots. Third, there is no equivalent to factor
columns in spark tables so class predictions are returned as
character columns. Fourth, to retain the model object for a new
R session (via \code{save}), the \code{model$fit} element of the \code{parsnip}
object should be serialized via \code{ml_save(object$fit)} and
separately saved to disk. In a new session, the object can be
reloaded and reattached to the \code{parsnip} object.
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are below:
\subsection{ranger}{\if{html}{\out{<div class="r">}}\preformatted{rand_forest() \%>\% 
  set_engine("ranger") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (regression)
## 
## Computational engine: ranger 
## 
## Model fit template:
## ranger::ranger(x = missing_arg(), y = missing_arg(), case.weights = missing_arg(), 
##     num.threads = 1, verbose = FALSE, seed = sample.int(10^5, 
##         1))
}\if{html}{\out{<div class="r">}}\preformatted{rand_forest() \%>\% 
  set_engine("ranger") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (classification)
## 
## Computational engine: ranger 
## 
## Model fit template:
## ranger::ranger(x = missing_arg(), y = missing_arg(), case.weights = missing_arg(), 
##     num.threads = 1, verbose = FALSE, seed = sample.int(10^5, 
##         1), probability = TRUE)
}

Note that \code{\link[ranger:ranger]{ranger::ranger()}} does not require factor
predictors to be converted to indicator variables. \code{fit()} does not
affect the encoding of the predictor values (i.e. factors stay factors)
for this model.

For \code{ranger} confidence intervals, the intervals are constructed using
the form \verb{estimate +/- z * std_error}. For classification probabilities,
these values can fall outside of \verb{[0, 1]} and will be coerced to be in
this range.
}

\subsection{randomForest}{\if{html}{\out{<div class="r">}}\preformatted{rand_forest() \%>\% 
  set_engine("randomForest") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (regression)
## 
## Computational engine: randomForest 
## 
## Model fit template:
## randomForest::randomForest(x = missing_arg(), y = missing_arg())
}\if{html}{\out{<div class="r">}}\preformatted{rand_forest() \%>\% 
  set_engine("randomForest") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (classification)
## 
## Computational engine: randomForest 
## 
## Model fit template:
## randomForest::randomForest(x = missing_arg(), y = missing_arg())
}

Note that \code{\link[randomForest:randomForest]{randomForest::randomForest()}}
does not require factor predictors to be converted to indicator
variables. \code{fit()} does not affect the encoding of the predictor values
(i.e. factors stay factors) for this model.
}

\subsection{spark}{\if{html}{\out{<div class="r">}}\preformatted{rand_forest() \%>\% 
  set_engine("spark") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (regression)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_random_forest(x = missing_arg(), formula = missing_arg(), 
##     type = "regression", seed = sample.int(10^5, 1))
}\if{html}{\out{<div class="r">}}\preformatted{rand_forest() \%>\% 
  set_engine("spark") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (classification)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_random_forest(x = missing_arg(), formula = missing_arg(), 
##     type = "classification", seed = sample.int(10^5, 1))
}

\code{fit()} does not affect the encoding of the predictor values
(i.e. factors stay factors) for this model.
}

\subsection{Parameter translations}{

The standardized parameter names in parsnip can be mapped to their
original names in each engine that has main parameters. Each engine
typically has a different default value (shown in parentheses) for each
parameter.\tabular{llll}{
   \strong{parsnip} \tab \strong{ranger} \tab \strong{randomForest} \tab \strong{spark} \cr
   mtry \tab mtry (see below) \tab mtry (see below) \tab feature_subset_strategy (see below) \cr
   trees \tab num.trees (500) \tab ntree (500) \tab num_trees (20) \cr
   min_n \tab min.node.size (see below) \tab nodesize (see below) \tab min_instances_per_node (1) \cr
}

\itemize{
\item For randomForest and spark, the default \code{mtry} is the square root of
the number of predictors for classification, and one-third of the
predictors for regression.
\item For ranger, the default \code{mtry} is the square root of the number of
predictors.
\item The default \code{min_n} for both ranger and randomForest is 1 for
classification and 5 for regression.
}
}
}

\examples{
show_engines("rand_forest")

rand_forest(mode = "classification", trees = 2000)
# Parameters can be represented by a placeholder:
rand_forest(mode = "regression", mtry = varying())
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=set_engine]{set_engine()}}, \code{\link[=update]{update()}}
}
