% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest_ranger.R
\name{details_rand_forest_ranger}
\alias{details_rand_forest_ranger}
\title{Random forests via ranger}
\description{
\code{\link[ranger:ranger]{ranger::ranger()}} fits a model that creates a large number of decision
trees, each independent of the others. The final prediction uses all
predictions from the individual trees and combines them.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{trees}: # Trees (type: integer, default: 500L)
\item \code{min_n}: Minimal Node Size (type: integer, default: see below)
}

\code{mtry} depends on the number of columns. The default in
\code{\link[ranger:ranger]{ranger::ranger()}} is \code{floor(sqrt(ncol(x)))}.

\code{min_n} depends on the mode. For regression, a value of 5 is the
default. For classification, a value of 10 is used.
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) \%>\%  
  set_engine("ranger") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: ranger 
## 
## Model fit template:
## ranger::ranger(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     mtry = min_cols(~integer(1), x), num.trees = integer(1), 
##     min.node.size = min_rows(~integer(1), x), num.threads = 1, 
##     verbose = FALSE, seed = sample.int(10^5, 1))
}\if{html}{\out{</div>}}

\code{min_rows()} and \code{min_cols()} will adjust the number of neighbors if the
chosen value if it is not consistent with the actual data dimensions.
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) \%>\% 
  set_engine("ranger") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: ranger 
## 
## Model fit template:
## ranger::ranger(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     mtry = min_cols(~integer(1), x), num.trees = integer(1), 
##     min.node.size = min_rows(~integer(1), x), num.threads = 1, 
##     verbose = FALSE, seed = sample.int(10^5, 1), probability = TRUE)
}\if{html}{\out{</div>}}

Note that a \code{ranger} probability forest is always fit (unless the
\code{probability} argument is changed by the user via
\code{\link[=set_engine]{set_engine()}}).
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Other notes}{

By default, parallel processing is turned off. When tuning, it is more
efficient to parallelize over the resamples and tuning parameters. To
parallelize the construction of the trees within the \code{ranger} model,
change the \code{num.threads} argument via \code{\link[=set_engine]{set_engine()}}.

For \code{ranger} confidence intervals, the intervals are constructed using
the form \verb{estimate +/- z * std_error}. For classification probabilities,
these values can fall outside of \verb{[0, 1]} and will be coerced to be in
this range.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Sparse Data}{

This model can utilize sparse data during model fitting and prediction.
Both sparse matrices such as dgCMatrix from the \code{Matrix} package and
sparse tibbles from the \code{sparsevctrs} package are supported. See
\link{sparse_data} for more information.

While this engine supports sparse data as an input, it doesn’t use it
any differently than dense data. Hence there it no reason to convert
back and forth.
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#rand-forest-ranger}{examples}
for \code{rand_forest()} with the \code{"ranger"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
