% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partykit.R
\name{max_mtry_formula}
\alias{max_mtry_formula}
\title{Determine largest value of mtry from formula.
This function potentially caps the value of \code{mtry} based on a formula and
data set. This is a safe approach for survival and/or multivariate models.}
\usage{
max_mtry_formula(mtry, formula, data)
}
\arguments{
\item{mtry}{An initial value of \code{mtry} (which may be too large).}

\item{formula}{A model formula.}

\item{data}{The training set (data frame).}
}
\value{
A value for \code{mtry}.
}
\description{
Determine largest value of mtry from formula.
This function potentially caps the value of \code{mtry} based on a formula and
data set. This is a safe approach for survival and/or multivariate models.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# should be 9
max_mtry_formula(200, cbind(wt, mpg) ~ ., data = mtcars)
\dontshow{\}) # examplesIf}
}
