% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{rvCoefficient}
\alias{rvCoefficient}
\alias{rvCoefficient,Partition,Partition-method}
\alias{rvCoefficient,PairCoefficients,missing-method}
\title{RV Coefficient}
\usage{
rvCoefficient(p, q)

\S4method{rvCoefficient}{Partition,Partition}(p, q)

\S4method{rvCoefficient}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the RV coefficient
\deqn{\frac{n + 2N_{11}(p)}{\sqrt{(2N_{21}(p) + n) (2N_{12}(p) + n)}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute the RV coefficient given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute the RV coefficient given the pair coefficients
}}

\examples{
rvCoefficient(new("Partition", c(0, 0, 0, 1, 1)), 
              new("Partition", c(0, 0, 1, 1, 1))) == 9 / 13

}
\references{
\insertRef{Robert1976}{partitionComparison}

\insertRef{Youness2004}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
