% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time_coercion.R
\name{vec_cast.partial_time.character}
\alias{vec_cast.partial_time.character}
\title{Coerce character date representations to parttime objects}
\usage{
\method{vec_cast}{partial_time.character}(x, to, ..., format = parse_iso8601_datetime, on.na = warning)
}
\arguments{
\item{x}{Vectors to cast.}

\item{to}{Type to cast to. If \code{NULL}, \code{x} will be returned as is.}

\item{...}{Additional arguments passed to \code{format} if a function is
provided.}

\item{format}{a \code{function} or \code{character} value. If a
\code{function}, it should accept a character vector and return a matrix of
parttime components. If a \code{character} it should provide a regular
exprssion which contains capture groups for each of the parttime
components.  See \link{parse_to_parttime_matrix}'s \code{regex} parameter
for more details.}

\item{on.na}{a \code{function} used to signal a condition for new \code{NA} values
introduced by coercion, a \code{character} value among \code{"error"}, \code{"warning"} or
\code{"suppress"} (for silencing messages) or \code{NULL} equivalent to \code{"suppress"}.}
}
\value{
A \code{partial_time} vector
}
\description{
Coerce character date representations to parttime objects
}
\examples{
dates <- c(
  NA,
  "2001",
  "2002-01-01",
  "2004-245", # yearday
  "2005-W13", # yearweek
  "2006-W02-5", # yearweek + weekday
  "2007-10-01T08",
  "2008-09-20T08:35",
  "2009-08-12T08:35.048", # fractional minute
  "2010-07-22T08:35:32",
  "2011-06-13T08:35:32.123", # fractional second
  "2012-05-23T08:35:32.123Z", # Zulu time
  "2013-04-14T08:35:32.123+05", # time offset from GMT
  "2014-03-24T08:35:32.123+05:30", # time offset with min from GMT
  "20150101T083532.123+0530" # condensed form
)

as.parttime(dates)

}
