% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_region_series.R
\name{slice_region_series}
\alias{slice_region_series}
\title{Extract a slice for a time series of climate variables for a region}
\usage{
slice_region_series(x, time_bp = NULL, time_ce = NULL)
}
\arguments{
\item{x}{climate time series generated with \code{\link[=region_series]{region_series()}}}

\item{time_bp}{time slice
in years before present (i.e. 1950, negative integers
for values in the past). The slices
need to exist in the dataset. To check which slices are available, you
can use \code{time_bp(x)}.}

\item{time_ce}{time slice in years CE. Only one of \code{time_bp} or \code{time_ce} should
be used.}
}
\value{
a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of the relevant slice.
}
\description{
This function extracts a time slice from time series of one or more climate
variables for a given dataset covering a region (or the whole world).
}
