% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{term_gene_graph}
\alias{term_gene_graph}
\title{Plot Term-Gene Graph}
\usage{
term_gene_graph(
  result_df,
  num_terms = 10,
  layout = "auto",
  use_description = FALSE,
  node_size = "num_genes"
)
}
\arguments{
\item{result_df}{A dataframe of pathfindR results that must contain the following columns: \describe{
  \item{Term_Description}{Description of the enriched term (necessary if \code{use_description = TRUE})}
  \item{ID}{ID of the enriched term (necessary if \code{use_description = FALSE})}
  \item{lowest_p}{the lowest adjusted-p value of the given term over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
}}

\item{num_terms}{Number of top enriched terms to use while creating the graph. Set to \code{NULL} to use
all enriched terms (default = 10, i.e. top 10 terms)}

\item{layout}{The type of layout to create (see \code{\link[ggraph]{ggraph}} for details. Default = "auto")}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the "Term_Description" column) should be used. (default = \code{FALSE})}

\item{node_size}{Argument to indicate whether to use number of significant genes ("num_genes")
or the -log10(lowest p value) ("p_val") for adjusting the node sizes (default = "num_genes")}
}
\value{
a  \code{\link[ggraph]{ggraph}} object containing the term-gene graph.
 Each node corresponds to an enriched term (beige), an up-regulated gene (green)
 or a down-regulated gene (red). An edge between a term and a gene indicates
 that the given term involves the gene. Size of a term node is proportional
 to either the number of genes (if \code{node_size = "num_genes"}) or
 the -log10(lowest p value) (if \code{node_size = "p_val"}).
}
\description{
Plot Term-Gene Graph
}
\details{
This function (adapted from the Gene-Concept network visualization
by the R package \code{enrichplot}) can be utilized to visualize which input
genes are involved in the enriched terms as a graph. The term-gene graph
shows the links between genes and biological terms and allows for the
investigation of multiple terms to which significant genes are related. The
graph also enables determination of the overlap between the enriched terms
by identifying shared and distinct significant term-related genes.
}
\examples{
p <- term_gene_graph(RA_output)
p <- term_gene_graph(RA_output, num_terms = 5)
p <- term_gene_graph(RA_output, node_size = "p_val")
}
