% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeTransformations.R
\name{getTimeTrans}
\alias{getTimeTrans}
\title{Get useful transformation for the time variable
in patient profiles.}
\usage{
getTimeTrans(
  type = c("asinh", "asinh-neg"),
  scale = 1,
  formatFct = prettyNum,
  n = 10
)
}
\arguments{
\item{type}{String with transformation type, either:
\itemize{
\item{'asinh': }{hyperbolic arc-sine (\code{\link{asinh}}) transformation}
\item{'asinh-neg': }{hyperbolic arc-sine transformation only for the negative values,
otherwise linear scale}
}}

\item{scale}{Numeric vector of length 1 (1 by default)
with size of the linear region around 0, only used if in case 
\code{type} is: 'asinh'.\cr
If specified, the time variable is first scaled with: \code{x/scale},
then transformed.}

\item{formatFct}{function formatting the time axis breaks,
(\code{\link{prettyNum}} by default),
see \code{format} parameter of the \code{\link[scales]{trans_new}}.}

\item{n}{Integer of length 1 with number of breaks, 10 by default.}
}
\value{
ggplot2 transformation (see \code{\link[scales]{trans_new}})
}
\description{
Get useful transformation for the time variable
in patient profiles.
}
\author{
Pieter-Jan Stiers, Laure Cougnaud
}
