\name{knobjs}
\alias{knobjs}
\docType{data}
\title{
Knowledge lists
}
\description{
A list of knwoledge list
}
\usage{data(knobjs)}
\format{
A list of lists that were generated using \code{\link{generate_our_knowledge}} function and updated using different strategy functions and sampling functions. The name of the object defines which strategy and which sampling function was used:
\itemize{
	\item \code{Rand}: \code{\link{random_design}} strategy
	\item \code{Act}: \code{\link{active_design}} strategy
	\item \code{Dream6}: \code{\link{dream6_design}} strategy
	\item \code{Sing}: \code{\link{sample_function_single_mod}} sampling function
	\item \code{Mult}: \code{\link{sample_function_multi_mod_weight}} sampling function
}
The integer at the end of the name is the random number generator seed used to perform the corresponding simulation.
}
\details{
The update performed by the strategies consists in filling the \code{experiments} slot of \code{knobj} with the sequence experiments performed. See \code{\link{exps}}. The corresponding data is available in the \code{datas} slot. This slot is a list. Each element of this list is a list with the following entries
\itemize{
	\item \code{manip}: the molecular perturbation performed, an element of \code{\link{experiment_list1}}
	\item \code{data}: the associated noisy observations, based on the chosen observable, an element of \code{\link{observables}}
	\item \code{thetas}: a posterior sample generated by the corresponding \code{\link{sample_function}}.
	\item \code{risks}: the risk associated to all potential new experiments computed by \code{\link{estimate_risk_out_all}}
}
The knowledge lists updated using \code{\link{random_design}} strategy do not provide any risk information.
}
\examples{
data(knobjs)
names(knobjs)

sapply(	
	1:length(knobjs),
	function(k){
		assign(names(knobjs)[k], knobjs[[k]], envir = .GlobalEnv)
	}
)
ls()
}
\keyword{datasets}
\keyword{Model specific objects}
