% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cieplot.R
\name{cieplot}
\alias{cieplot}
\title{CIE plot}
\usage{
cieplot(ciedata, mono = TRUE, out.lwd = NULL, out.lcol = "black",
  out.lty = 1, view = 70, scale.y = 0.45, axis = FALSE, grid = FALSE,
  xlim = c(-12.8, 12.7), ylim = c(-12.8, 12.7), zlim = c(0, 10),
  margin = c(1, 1, 1, 1), ...)
}
\arguments{
\item{ciedata}{(required)}

\item{mono}{should the monochromatic loci (the 'horseshoe') be
plotted? Defaults to \code{TRUE}.}

\item{out.lwd, out.lcol, out.lty}{graphical parameters for the monochromatic loci outline.}

\item{view}{orientation of the 3d plot in degrees, when \code{space = 'cielab'} (defaults to 70).}

\item{scale.y}{numeric. Perspective scaling of the y axis (defaults to \code{0.45}).}

\item{axis}{logical. Draw X, Y and Z axis (defaults to \code{FALSE}).}

\item{grid}{logical. Draw grid (defaults to \code{FALSE}).}

\item{xlim, ylim, zlim}{axis limits}

\item{margin}{vector of four numbers specifying drawing margins (defaults to c(1,1,1,1))}

\item{...}{Additional graphical options. See \code{\link{par}}.}
}
\description{
Plot a CIE (XYZ or LAB) chromaticity diagram.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'cie2', illum = 'D65')
cie.flowers <- colspace(vis.flowers, space = 'ciexyz')
plot(cie.flowers)
}

}
\references{
Smith T, Guild J. (1932) The CIE colorimetric standards and their use.
   Transactions of the Optical Society, 33(3), 73-134.

Westland S, Ripamonti C, Cheung V. (2012). Computational colour science 
   using MATLAB. John Wiley & Sons.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
