% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coc.R
\name{coc}
\alias{coc}
\title{Color opponent coding model}
\usage{
coc(vismodeldata)
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a data frame
with three columns representing trichromatic viewer).}
}
\value{
A data frame of class \code{colspace} consisting of the following columns:

\code{s}, \code{m}, \code{l}: the quantum catch data used to calculate 
 the remaining variables.

\code{x}, \code{y}: coordinates for the points in coc space

\code{r.vec}: the r vector (saturation, distance from the center using
 a city-block metric).
}
\description{
Calculates coordinates and colorimetric variables that represent reflectance spectra
in the color opponent coding model of hymenopteran vision.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'apis', qcatch = 'Ei', relative = FALSE, vonkries = TRUE)
coc.flowers <- colspace(vis.flowers, space = 'coc')
} 

}
\references{
Backhaus W. (1991). Color opponent coding in the visual system
 of the honeybee. Vision Research, 31, 1381-1397.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
