% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.rspec.R
\name{merge.rspec}
\alias{merge.rspec}
\title{Merge two rspec objects}
\usage{
\method{merge}{rspec}(x, y, ...)
}
\arguments{
\item{x, y}{(required) \code{rspec} objects to merge.}

\item{...}{additional class arguments.}
}
\value{
an object of class \code{rspec} for use with \code{pavo} functions.
Will use \code{by = "wl"} if unspecified, or automatically append \code{wl} to the
\code{by} argument if one is specified.
}
\description{
Merges two \code{rspec} or \code{data.frame} objects into a single \code{rspec} object.
}
\examples{

# Load and split dataset into 2 sections
data(teal)
teal1 <- teal[, c(1, 3:5)]
teal2 <- teal[, c(1, 2, 6:12)]
teal.mer <- merge(teal1, teal2, by = "wl")
head(teal.mer)
par(mfrow = c(1, 2))
plot(teal.mer)
plot(teal)
}
\seealso{
\code{\link{as.rspec}}, \code{\link{aggspec}}
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}
}
