% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.rspec.R
\name{subset.rspec}
\alias{subset.rspec}
\alias{subset.colspace}
\alias{subset.vismodel}
\title{Subset rspec, vismodel, and colspace objects}
\usage{
\method{subset}{rspec}(x, subset, ...)

\method{subset}{colspace}(x, subset, ...)

\method{subset}{vismodel}(x, subset, ...)
}
\arguments{
\item{x}{(required) an object of class \code{rspec}, \code{vismodel}, or
\code{colspace}, containing spectra, visual model output or colourspace data
to subset.}

\item{subset}{a string used for partial matching of observations.}

\item{...}{additional attributes passed to \code{grep}. Ignored if
\code{subset} is logical.}
}
\value{
a subsetted object of the same class as the input object.
}
\description{
Subsets various object types based on a given vector or grep partial matching
of data names.
}
\note{
if more than one value is given to \code{subset}, any spectra that
matches \emph{either} condition will be included. It's a union, not an
intersect.
}
\examples{
data(sicalis)
vis.sicalis <- vismodel(sicalis)
tcs.sicalis <- colspace(vis.sicalis, space = "tcs")

# Subset all 'crown' patches (C in file names)
head(subset(sicalis, "C"))
subset(vis.sicalis, "C")
subset(tcs.sicalis, "C")[, seq_len(5)]
subset(sicalis, c("B", "C"))
subset(sicalis, "T", invert = TRUE)
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}
}
