% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getimg.R
\name{getimg}
\alias{getimg}
\title{Import image data}
\usage{
getimg(imgpath = getwd(), subdir = FALSE, subdir.names = FALSE, max.size = 1)
}
\arguments{
\item{imgpath}{(required) either the full file-path or URL to an image (including extension),
or the path to a folder in which multiple image files are located. Mixed file formats
within a folder are accepted.}

\item{subdir}{should subdirectories within the \code{imgpath} folder be
included in the search? (defaults to \code{FALSE}).}

\item{subdir.names}{should subdirectory path be included in the name of the
images? (defaults to \code{FALSE}).}

\item{max.size}{maximum size of all images to be allowed in memory, in GB. Defaults to
\code{1}.}
}
\value{
a image, or list of images, of class \code{rimg}, for use in further
\code{pavo} functions.
}
\description{
Finds and imports PNG, JPEG, and/or BMP images.
}
\examples{
# Single image
papilio <- getimg(system.file("testdata/images/butterflies/papilio.png", package = "pavo"))

# Multiple images
snakes <- getimg(system.file("testdata/images/snakes", package = "pavo"))
}
\author{
Thomas E. White \email{thomas.white026@gmail.com}
}
