# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Managed Streaming for Kafka
#'
#' @description
#' The operations for managing an Amazon MSK cluster.
#'
#' @examples
#' \donttest{svc <- kafka()
#' svc$create_cluster(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=kafka_create_cluster]{create_cluster} \tab Creates a new MSK cluster \cr
#'  \link[=kafka_delete_cluster]{delete_cluster} \tab Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request \cr
#'  \link[=kafka_describe_cluster]{describe_cluster} \tab Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request\cr
#'  \link[=kafka_get_bootstrap_brokers]{get_bootstrap_brokers} \tab A list of brokers that a client application can use to bootstrap \cr
#'  \link[=kafka_list_clusters]{list_clusters} \tab Returns a list of clusters in an account \cr
#'  \link[=kafka_list_nodes]{list_nodes} \tab Returns a list of the broker nodes in the cluster 
#' }
#'
#' @rdname kafka
#' @export
kafka <- function() {
  .kafka$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.kafka <- list()

.kafka$operations <- list()

.kafka$metadata <- list(
  service_name = "kafka",
  endpoints = list("*" = "kafka.{region}.amazonaws.com", "cn-*" = "kafka.{region}.amazonaws.com.cn"),
  service_id = "Kafka",
  api_version = "2018-11-14",
  signing_name = "kafka",
  json_version = "1.1",
  target_prefix = ""
)

.kafka$handlers <- new_handlers("restjson", "v4")

.kafka$service <- function() {
  new_service(.kafka$metadata, .kafka$handlers)
}
