% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_start_application}
\alias{kinesisanalytics_start_application}
\title{Starts the specified Amazon Kinesis Analytics application}
\usage{
kinesisanalytics_start_application(ApplicationName, InputConfigurations)
}
\arguments{
\item{ApplicationName}{[required] Name of the application.}

\item{InputConfigurations}{[required] Identifies the specific input, by ID, that the application starts
consuming. Amazon Kinesis Analytics starts reading the streaming source
associated with the input. You can also specify where in the streaming
source you want Amazon Kinesis Analytics to start reading.}
}
\description{
Starts the specified Amazon Kinesis Analytics application. After
creating an application, you must exclusively call this operation to
start your application.
}
\details{
After the application starts, it begins consuming the input data,
processes it, and writes the output to the configured destination.

The application status must be \code{READY} for you to start an application.
You can get the application status in the console or using the
DescribeApplication operation.

After you start the application, you can stop the application from
processing the input by calling the StopApplication operation.

This operation requires permissions to perform the
\code{kinesisanalytics:StartApplication} action.
}
\section{Request syntax}{
\preformatted{svc$start_application(
  ApplicationName = "string",
  InputConfigurations = list(
    list(
      Id = "string",
      InputStartingPositionConfiguration = list(
        InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
      )
    )
  )
)
}
}

\keyword{internal}
