% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_describe_delivery_stream}
\alias{firehose_describe_delivery_stream}
\title{Describes the specified delivery stream and its status}
\usage{
firehose_describe_delivery_stream(DeliveryStreamName, Limit,
  ExclusiveStartDestinationId)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}

\item{Limit}{The limit on the number of destinations to return. You can have one
destination per delivery stream.}

\item{ExclusiveStartDestinationId}{The ID of the destination to start returning the destination
information. Kinesis Data Firehose supports one destination per delivery
stream.}
}
\description{
Describes the specified delivery stream and its status. For example,
after your delivery stream is created, call \code{DescribeDeliveryStream} to
see whether the delivery stream is \code{ACTIVE} and therefore ready for data
to be sent to it.

If the status of a delivery stream is \code{CREATING_FAILED}, this status
doesn't change, and you can't invoke CreateDeliveryStream again on it.
However, you can invoke the DeleteDeliveryStream operation to delete it.
If the status is \code{DELETING_FAILED}, you can force deletion by invoking
DeleteDeliveryStream again but with
DeleteDeliveryStreamInput$AllowForceDelete set to true.
}
\section{Request syntax}{
\preformatted{svc$describe_delivery_stream(
  DeliveryStreamName = "string",
  Limit = 123,
  ExclusiveStartDestinationId = "string"
)
}
}

\keyword{internal}
