% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_column_statistics_for_table}
\alias{glue_get_column_statistics_for_table}
\title{Retrieves table statistics of columns}
\usage{
glue_get_column_statistics_for_table(CatalogId, DatabaseName, TableName,
  ColumnNames)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the partitions in question reside. If
none is supplied, the AWS account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database where the partitions reside.}

\item{TableName}{[required] The name of the partitions' table.}

\item{ColumnNames}{[required] A list of the column names.}
}
\description{
Retrieves table statistics of columns.

The Identity and Access Management (IAM) permission required for this
operation is \code{GetTable}.
}
\section{Request syntax}{
\preformatted{svc$get_column_statistics_for_table(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  ColumnNames = list(
    "string"
  )
)
}
}

\keyword{internal}
