# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kinesisanalytics_service.R
NULL

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Adds a CloudWatch log stream to monitor application configuration
#' errors. For more information about using CloudWatch log streams with
#' Amazon Kinesis Analytics applications, see [Working with Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
#'
#' @usage
#' kinesisanalytics_add_application_cloud_watch_logging_option(
#'   ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOption)
#'
#' @param ApplicationName &#91;required&#93; The Kinesis Analytics application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The version ID of the Kinesis Analytics application.
#' @param CloudWatchLoggingOption &#91;required&#93; Provides the CloudWatch log stream Amazon Resource Name (ARN) and the
#' IAM role ARN. Note: To write application messages to CloudWatch, the IAM
#' role that is used must have the `PutLogEvents` policy action enabled.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_cloud_watch_logging_option(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   CloudWatchLoggingOption = list(
#'     LogStreamARN = "string",
#'     RoleARN = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_add_application_cloud_watch_logging_option
kinesisanalytics_add_application_cloud_watch_logging_option <- function(ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOption) {
  op <- new_operation(
    name = "AddApplicationCloudWatchLoggingOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$add_application_cloud_watch_logging_option_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, CloudWatchLoggingOption = CloudWatchLoggingOption)
  output <- .kinesisanalytics$add_application_cloud_watch_logging_option_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$add_application_cloud_watch_logging_option <- kinesisanalytics_add_application_cloud_watch_logging_option

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Adds a streaming source to your Amazon Kinesis application. For
#' conceptual information, see [Configuring Application
#' Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
#' 
#' You can add a streaming source either when you create an application or
#' you can use this operation to add a streaming source after you create an
#' application. For more information, see
#' [`create_application`][kinesisanalytics_create_application].
#' 
#' Any configuration update, including adding a streaming source using this
#' operation, results in a new version of the application. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to find the current application version.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:AddApplicationInput` action.
#'
#' @usage
#' kinesisanalytics_add_application_input(ApplicationName,
#'   CurrentApplicationVersionId, Input)
#'
#' @param ApplicationName &#91;required&#93; Name of your existing Amazon Kinesis Analytics application to which you
#' want to add the streaming source.
#' @param CurrentApplicationVersionId &#91;required&#93; Current version of your Amazon Kinesis Analytics application. You can
#' use the [`describe_application`][kinesisanalytics_describe_application]
#' operation to find the current application version.
#' @param Input &#91;required&#93; The
#' [Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html)
#' to add.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_input(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   Input = list(
#'     NamePrefix = "string",
#'     InputProcessingConfiguration = list(
#'       InputLambdaProcessor = list(
#'         ResourceARN = "string",
#'         RoleARN = "string"
#'       )
#'     ),
#'     KinesisStreamsInput = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     ),
#'     KinesisFirehoseInput = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     ),
#'     InputParallelism = list(
#'       Count = 123
#'     ),
#'     InputSchema = list(
#'       RecordFormat = list(
#'         RecordFormatType = "JSON"|"CSV",
#'         MappingParameters = list(
#'           JSONMappingParameters = list(
#'             RecordRowPath = "string"
#'           ),
#'           CSVMappingParameters = list(
#'             RecordRowDelimiter = "string",
#'             RecordColumnDelimiter = "string"
#'           )
#'         )
#'       ),
#'       RecordEncoding = "string",
#'       RecordColumns = list(
#'         list(
#'           Name = "string",
#'           Mapping = "string",
#'           SqlType = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_add_application_input
kinesisanalytics_add_application_input <- function(ApplicationName, CurrentApplicationVersionId, Input) {
  op <- new_operation(
    name = "AddApplicationInput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$add_application_input_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, Input = Input)
  output <- .kinesisanalytics$add_application_input_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$add_application_input <- kinesisanalytics_add_application_input

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Adds an
#' [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
#' to an application. An input processor preprocesses records on the input
#' stream before the application's SQL code executes. Currently, the only
#' input processor available is [AWS
#' Lambda](https://docs.aws.amazon.com/lambda/).
#'
#' @usage
#' kinesisanalytics_add_application_input_processing_configuration(
#'   ApplicationName, CurrentApplicationVersionId, InputId,
#'   InputProcessingConfiguration)
#'
#' @param ApplicationName &#91;required&#93; Name of the application to which you want to add the input processing
#' configuration.
#' @param CurrentApplicationVersionId &#91;required&#93; Version of the application to which you want to add the input processing
#' configuration. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param InputId &#91;required&#93; The ID of the input configuration to add the input processing
#' configuration to. You can get a list of the input IDs for an application
#' using the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation.
#' @param InputProcessingConfiguration &#91;required&#93; The
#' [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
#' to add to the application.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_input_processing_configuration(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   InputId = "string",
#'   InputProcessingConfiguration = list(
#'     InputLambdaProcessor = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_add_application_input_processing_configuration
kinesisanalytics_add_application_input_processing_configuration <- function(ApplicationName, CurrentApplicationVersionId, InputId, InputProcessingConfiguration) {
  op <- new_operation(
    name = "AddApplicationInputProcessingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$add_application_input_processing_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, InputId = InputId, InputProcessingConfiguration = InputProcessingConfiguration)
  output <- .kinesisanalytics$add_application_input_processing_configuration_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$add_application_input_processing_configuration <- kinesisanalytics_add_application_input_processing_configuration

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Adds an external destination to your Amazon Kinesis Analytics
#' application.
#' 
#' If you want Amazon Kinesis Analytics to deliver data from an
#' in-application stream within your application to an external destination
#' (such as an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery
#' stream, or an AWS Lambda function), you add the relevant configuration
#' to your application using this operation. You can configure one or more
#' outputs for your application. Each output configuration maps an
#' in-application stream and an external destination.
#' 
#' You can use one of the output configurations to deliver data from your
#' in-application error stream to an external destination so that you can
#' analyze the errors. For more information, see [Understanding Application
#' Output
#' (Destination)](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
#' 
#' Any configuration update, including adding a streaming source using this
#' operation, results in a new version of the application. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to find the current application version.
#' 
#' For the limits on the number of application inputs and outputs you can
#' configure, see
#' [Limits](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:AddApplicationOutput` action.
#'
#' @usage
#' kinesisanalytics_add_application_output(ApplicationName,
#'   CurrentApplicationVersionId, Output)
#'
#' @param ApplicationName &#91;required&#93; Name of the application to which you want to add the output
#' configuration.
#' @param CurrentApplicationVersionId &#91;required&#93; Version of the application to which you want to add the output
#' configuration. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param Output &#91;required&#93; An array of objects, each describing one output configuration. In the
#' output configuration, you specify the name of an in-application stream,
#' a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis
#' Firehose delivery stream, or an AWS Lambda function), and record the
#' formation to use when writing to the destination.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_output(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   Output = list(
#'     Name = "string",
#'     KinesisStreamsOutput = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     ),
#'     KinesisFirehoseOutput = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     ),
#'     LambdaOutput = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     ),
#'     DestinationSchema = list(
#'       RecordFormatType = "JSON"|"CSV"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_add_application_output
kinesisanalytics_add_application_output <- function(ApplicationName, CurrentApplicationVersionId, Output) {
  op <- new_operation(
    name = "AddApplicationOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$add_application_output_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, Output = Output)
  output <- .kinesisanalytics$add_application_output_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$add_application_output <- kinesisanalytics_add_application_output

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Adds a reference data source to an existing application.
#' 
#' Amazon Kinesis Analytics reads reference data (that is, an Amazon S3
#' object) and creates an in-application table within your application. In
#' the request, you provide the source (S3 bucket name and object key
#' name), name of the in-application table to create, and the necessary
#' mapping information that describes how data in Amazon S3 object maps to
#' columns in the resulting in-application table.
#' 
#' For conceptual information, see [Configuring Application
#' Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
#' For the limits on data sources you can add to your application, see
#' [Limits](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:AddApplicationOutput` action.
#'
#' @usage
#' kinesisanalytics_add_application_reference_data_source(ApplicationName,
#'   CurrentApplicationVersionId, ReferenceDataSource)
#'
#' @param ApplicationName &#91;required&#93; Name of an existing application.
#' @param CurrentApplicationVersionId &#91;required&#93; Version of the application for which you are adding the reference data
#' source. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param ReferenceDataSource &#91;required&#93; The reference data source can be an object in your Amazon S3 bucket.
#' Amazon Kinesis Analytics reads the object and copies the data into the
#' in-application table that is created. You provide an S3 bucket, object
#' key name, and the resulting in-application table that is created. You
#' must also provide an IAM role with the necessary permissions that Amazon
#' Kinesis Analytics can assume to read the object from your S3 bucket on
#' your behalf.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_reference_data_source(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   ReferenceDataSource = list(
#'     TableName = "string",
#'     S3ReferenceDataSource = list(
#'       BucketARN = "string",
#'       FileKey = "string",
#'       ReferenceRoleARN = "string"
#'     ),
#'     ReferenceSchema = list(
#'       RecordFormat = list(
#'         RecordFormatType = "JSON"|"CSV",
#'         MappingParameters = list(
#'           JSONMappingParameters = list(
#'             RecordRowPath = "string"
#'           ),
#'           CSVMappingParameters = list(
#'             RecordRowDelimiter = "string",
#'             RecordColumnDelimiter = "string"
#'           )
#'         )
#'       ),
#'       RecordEncoding = "string",
#'       RecordColumns = list(
#'         list(
#'           Name = "string",
#'           Mapping = "string",
#'           SqlType = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_add_application_reference_data_source
kinesisanalytics_add_application_reference_data_source <- function(ApplicationName, CurrentApplicationVersionId, ReferenceDataSource) {
  op <- new_operation(
    name = "AddApplicationReferenceDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$add_application_reference_data_source_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ReferenceDataSource = ReferenceDataSource)
  output <- .kinesisanalytics$add_application_reference_data_source_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$add_application_reference_data_source <- kinesisanalytics_add_application_reference_data_source

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Creates an Amazon Kinesis Analytics application. You can configure each
#' application with one streaming source as input, application code to
#' process the input, and up to three destinations where you want Amazon
#' Kinesis Analytics to write the output data from your application. For an
#' overview, see [How it
#' Works](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works.html).
#' 
#' In the input configuration, you map the streaming source to an
#' in-application stream, which you can think of as a constantly updating
#' table. In the mapping, you must provide a schema for the in-application
#' stream and map each data column in the in-application stream to a data
#' element in the streaming source.
#' 
#' Your application code is one or more SQL statements that read input
#' data, transform it, and generate output. Your application code can
#' create one or more SQL artifacts like SQL streams or pumps.
#' 
#' In the output configuration, you can configure the application to write
#' data from in-application streams created in your applications to up to
#' three destinations.
#' 
#' To read data from your source stream or write data to destination
#' streams, Amazon Kinesis Analytics needs your permissions. You grant
#' these permissions by creating IAM roles. This operation requires
#' permissions to perform the `kinesisanalytics:CreateApplication` action.
#' 
#' For introductory exercises to create an Amazon Kinesis Analytics
#' application, see [Getting
#' Started](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/getting-started.html).
#'
#' @usage
#' kinesisanalytics_create_application(ApplicationName,
#'   ApplicationDescription, Inputs, Outputs, CloudWatchLoggingOptions,
#'   ApplicationCode, Tags)
#'
#' @param ApplicationName &#91;required&#93; Name of your Amazon Kinesis Analytics application (for example,
#' `sample-app`).
#' @param ApplicationDescription Summary description of the application.
#' @param Inputs Use this parameter to configure the application input.
#' 
#' You can configure your application to receive input from a single
#' streaming source. In this configuration, you map this streaming source
#' to an in-application stream that is created. Your application code can
#' then query the in-application stream like a table (you can think of it
#' as a constantly updating table).
#' 
#' For the streaming source, you provide its Amazon Resource Name (ARN) and
#' format of data on the stream (for example, JSON, CSV, etc.). You also
#' must provide an IAM role that Amazon Kinesis Analytics can assume to
#' read this stream on your behalf.
#' 
#' To create the in-application stream, you need to specify a schema to
#' transform your data into a schematized version used in SQL. In the
#' schema, you provide the necessary mapping of the data elements in the
#' streaming source to record columns in the in-app stream.
#' @param Outputs You can configure application output to write data from any of the
#' in-application streams to up to three destinations.
#' 
#' These destinations can be Amazon Kinesis streams, Amazon Kinesis
#' Firehose delivery streams, AWS Lambda destinations, or any combination
#' of the three.
#' 
#' In the configuration, you specify the in-application stream name, the
#' destination stream or Lambda function Amazon Resource Name (ARN), and
#' the format to use when writing data. You must also provide an IAM role
#' that Amazon Kinesis Analytics can assume to write to the destination
#' stream or Lambda function on your behalf.
#' 
#' In the output configuration, you also provide the output stream or
#' Lambda function ARN. For stream destinations, you provide the format of
#' data in the stream (for example, JSON, CSV). You also must provide an
#' IAM role that Amazon Kinesis Analytics can assume to write to the stream
#' or Lambda function on your behalf.
#' @param CloudWatchLoggingOptions Use this parameter to configure a CloudWatch log stream to monitor
#' application configuration errors. For more information, see [Working
#' with Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
#' @param ApplicationCode One or more SQL statements that read input data, transform it, and
#' generate output. For example, you can write a SQL statement that reads
#' data from one in-application stream, generates a running average of the
#' number of advertisement clicks by vendor, and insert resulting rows in
#' another in-application stream using pumps. For more information about
#' the typical pattern, see [Application
#' Code](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html).
#' 
#' You can provide such series of SQL statements, where output of one
#' statement can be used as the input for the next statement. You store
#' intermediate results by creating in-application streams and pumps.
#' 
#' Note that the application code must create the streams with names
#' specified in the `Outputs`. For example, if your `Outputs` defines
#' output streams named `ExampleOutputStream1` and `ExampleOutputStream2`,
#' then your application code must create these streams.
#' @param Tags A list of one or more tags to assign to the application. A tag is a
#' key-value pair that identifies an application. Note that the maximum
#' number of application tags includes system tags. The maximum number of
#' user-defined application tags is 50. For more information, see [Using
#' Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationSummary = list(
#'     ApplicationName = "string",
#'     ApplicationARN = "string",
#'     ApplicationStatus = "DELETING"|"STARTING"|"STOPPING"|"READY"|"RUNNING"|"UPDATING"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   ApplicationName = "string",
#'   ApplicationDescription = "string",
#'   Inputs = list(
#'     list(
#'       NamePrefix = "string",
#'       InputProcessingConfiguration = list(
#'         InputLambdaProcessor = list(
#'           ResourceARN = "string",
#'           RoleARN = "string"
#'         )
#'       ),
#'       KinesisStreamsInput = list(
#'         ResourceARN = "string",
#'         RoleARN = "string"
#'       ),
#'       KinesisFirehoseInput = list(
#'         ResourceARN = "string",
#'         RoleARN = "string"
#'       ),
#'       InputParallelism = list(
#'         Count = 123
#'       ),
#'       InputSchema = list(
#'         RecordFormat = list(
#'           RecordFormatType = "JSON"|"CSV",
#'           MappingParameters = list(
#'             JSONMappingParameters = list(
#'               RecordRowPath = "string"
#'             ),
#'             CSVMappingParameters = list(
#'               RecordRowDelimiter = "string",
#'               RecordColumnDelimiter = "string"
#'             )
#'           )
#'         ),
#'         RecordEncoding = "string",
#'         RecordColumns = list(
#'           list(
#'             Name = "string",
#'             Mapping = "string",
#'             SqlType = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Outputs = list(
#'     list(
#'       Name = "string",
#'       KinesisStreamsOutput = list(
#'         ResourceARN = "string",
#'         RoleARN = "string"
#'       ),
#'       KinesisFirehoseOutput = list(
#'         ResourceARN = "string",
#'         RoleARN = "string"
#'       ),
#'       LambdaOutput = list(
#'         ResourceARN = "string",
#'         RoleARN = "string"
#'       ),
#'       DestinationSchema = list(
#'         RecordFormatType = "JSON"|"CSV"
#'       )
#'     )
#'   ),
#'   CloudWatchLoggingOptions = list(
#'     list(
#'       LogStreamARN = "string",
#'       RoleARN = "string"
#'     )
#'   ),
#'   ApplicationCode = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_create_application
kinesisanalytics_create_application <- function(ApplicationName, ApplicationDescription = NULL, Inputs = NULL, Outputs = NULL, CloudWatchLoggingOptions = NULL, ApplicationCode = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$create_application_input(ApplicationName = ApplicationName, ApplicationDescription = ApplicationDescription, Inputs = Inputs, Outputs = Outputs, CloudWatchLoggingOptions = CloudWatchLoggingOptions, ApplicationCode = ApplicationCode, Tags = Tags)
  output <- .kinesisanalytics$create_application_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$create_application <- kinesisanalytics_create_application

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Deletes the specified application. Amazon Kinesis Analytics halts
#' application execution and deletes the application, including any
#' application artifacts (such as in-application streams, reference table,
#' and application code).
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:DeleteApplication` action.
#'
#' @usage
#' kinesisanalytics_delete_application(ApplicationName, CreateTimestamp)
#'
#' @param ApplicationName &#91;required&#93; Name of the Amazon Kinesis Analytics application to delete.
#' @param CreateTimestamp &#91;required&#93; You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get this value.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ApplicationName = "string",
#'   CreateTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_delete_application
kinesisanalytics_delete_application <- function(ApplicationName, CreateTimestamp) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$delete_application_input(ApplicationName = ApplicationName, CreateTimestamp = CreateTimestamp)
  output <- .kinesisanalytics$delete_application_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$delete_application <- kinesisanalytics_delete_application

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Deletes a CloudWatch log stream from an application. For more
#' information about using CloudWatch log streams with Amazon Kinesis
#' Analytics applications, see [Working with Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
#'
#' @usage
#' kinesisanalytics_delete_application_cloud_watch_logging_option(
#'   ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOptionId)
#'
#' @param ApplicationName &#91;required&#93; The Kinesis Analytics application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The version ID of the Kinesis Analytics application.
#' @param CloudWatchLoggingOptionId &#91;required&#93; The `CloudWatchLoggingOptionId` of the CloudWatch logging option to
#' delete. You can get the `CloudWatchLoggingOptionId` by using the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_cloud_watch_logging_option(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   CloudWatchLoggingOptionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_delete_application_cloud_watch_logging_option
kinesisanalytics_delete_application_cloud_watch_logging_option <- function(ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOptionId) {
  op <- new_operation(
    name = "DeleteApplicationCloudWatchLoggingOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$delete_application_cloud_watch_logging_option_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, CloudWatchLoggingOptionId = CloudWatchLoggingOptionId)
  output <- .kinesisanalytics$delete_application_cloud_watch_logging_option_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$delete_application_cloud_watch_logging_option <- kinesisanalytics_delete_application_cloud_watch_logging_option

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Deletes an
#' [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
#' from an input.
#'
#' @usage
#' kinesisanalytics_delete_application_input_processing_configuration(
#'   ApplicationName, CurrentApplicationVersionId, InputId)
#'
#' @param ApplicationName &#91;required&#93; The Kinesis Analytics application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The version ID of the Kinesis Analytics application.
#' @param InputId &#91;required&#93; The ID of the input configuration from which to delete the input
#' processing configuration. You can get a list of the input IDs for an
#' application by using the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_input_processing_configuration(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   InputId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_delete_application_input_processing_configuration
kinesisanalytics_delete_application_input_processing_configuration <- function(ApplicationName, CurrentApplicationVersionId, InputId) {
  op <- new_operation(
    name = "DeleteApplicationInputProcessingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$delete_application_input_processing_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, InputId = InputId)
  output <- .kinesisanalytics$delete_application_input_processing_configuration_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$delete_application_input_processing_configuration <- kinesisanalytics_delete_application_input_processing_configuration

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Deletes output destination configuration from your application
#' configuration. Amazon Kinesis Analytics will no longer write data from
#' the corresponding in-application stream to the external output
#' destination.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:DeleteApplicationOutput` action.
#'
#' @usage
#' kinesisanalytics_delete_application_output(ApplicationName,
#'   CurrentApplicationVersionId, OutputId)
#'
#' @param ApplicationName &#91;required&#93; Amazon Kinesis Analytics application name.
#' @param CurrentApplicationVersionId &#91;required&#93; Amazon Kinesis Analytics application version. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param OutputId &#91;required&#93; The ID of the configuration to delete. Each output configuration that is
#' added to the application, either when the application is created or
#' later using the
#' [`add_application_output`][kinesisanalytics_add_application_output]
#' operation, has a unique ID. You need to provide the ID to uniquely
#' identify the output configuration that you want to delete from the
#' application configuration. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the specific `OutputId`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_output(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   OutputId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_delete_application_output
kinesisanalytics_delete_application_output <- function(ApplicationName, CurrentApplicationVersionId, OutputId) {
  op <- new_operation(
    name = "DeleteApplicationOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$delete_application_output_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, OutputId = OutputId)
  output <- .kinesisanalytics$delete_application_output_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$delete_application_output <- kinesisanalytics_delete_application_output

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Deletes a reference data source configuration from the specified
#' application configuration.
#' 
#' If the application is running, Amazon Kinesis Analytics immediately
#' removes the in-application table that you created using the
#' [`add_application_reference_data_source`][kinesisanalytics_add_application_reference_data_source]
#' operation.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics.DeleteApplicationReferenceDataSource` action.
#'
#' @usage
#' kinesisanalytics_delete_application_reference_data_source(
#'   ApplicationName, CurrentApplicationVersionId, ReferenceId)
#'
#' @param ApplicationName &#91;required&#93; Name of an existing application.
#' @param CurrentApplicationVersionId &#91;required&#93; Version of the application. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param ReferenceId &#91;required&#93; ID of the reference data source. When you add a reference data source to
#' your application using the
#' [`add_application_reference_data_source`][kinesisanalytics_add_application_reference_data_source],
#' Amazon Kinesis Analytics assigns an ID. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get the reference ID.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_reference_data_source(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   ReferenceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_delete_application_reference_data_source
kinesisanalytics_delete_application_reference_data_source <- function(ApplicationName, CurrentApplicationVersionId, ReferenceId) {
  op <- new_operation(
    name = "DeleteApplicationReferenceDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$delete_application_reference_data_source_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ReferenceId = ReferenceId)
  output <- .kinesisanalytics$delete_application_reference_data_source_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$delete_application_reference_data_source <- kinesisanalytics_delete_application_reference_data_source

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Returns information about a specific Amazon Kinesis Analytics
#' application.
#' 
#' If you want to retrieve a list of all applications in your account, use
#' the [`list_applications`][kinesisanalytics_list_applications] operation.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:DescribeApplication` action. You can use
#' [`describe_application`][kinesisanalytics_describe_application] to get
#' the current application versionId, which you need to call other
#' operations such as `Update`.
#'
#' @usage
#' kinesisanalytics_describe_application(ApplicationName)
#'
#' @param ApplicationName &#91;required&#93; Name of the application.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationDetail = list(
#'     ApplicationName = "string",
#'     ApplicationDescription = "string",
#'     ApplicationARN = "string",
#'     ApplicationStatus = "DELETING"|"STARTING"|"STOPPING"|"READY"|"RUNNING"|"UPDATING",
#'     CreateTimestamp = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastUpdateTimestamp = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     InputDescriptions = list(
#'       list(
#'         InputId = "string",
#'         NamePrefix = "string",
#'         InAppStreamNames = list(
#'           "string"
#'         ),
#'         InputProcessingConfigurationDescription = list(
#'           InputLambdaProcessorDescription = list(
#'             ResourceARN = "string",
#'             RoleARN = "string"
#'           )
#'         ),
#'         KinesisStreamsInputDescription = list(
#'           ResourceARN = "string",
#'           RoleARN = "string"
#'         ),
#'         KinesisFirehoseInputDescription = list(
#'           ResourceARN = "string",
#'           RoleARN = "string"
#'         ),
#'         InputSchema = list(
#'           RecordFormat = list(
#'             RecordFormatType = "JSON"|"CSV",
#'             MappingParameters = list(
#'               JSONMappingParameters = list(
#'                 RecordRowPath = "string"
#'               ),
#'               CSVMappingParameters = list(
#'                 RecordRowDelimiter = "string",
#'                 RecordColumnDelimiter = "string"
#'               )
#'             )
#'           ),
#'           RecordEncoding = "string",
#'           RecordColumns = list(
#'             list(
#'               Name = "string",
#'               Mapping = "string",
#'               SqlType = "string"
#'             )
#'           )
#'         ),
#'         InputParallelism = list(
#'           Count = 123
#'         ),
#'         InputStartingPositionConfiguration = list(
#'           InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
#'         )
#'       )
#'     ),
#'     OutputDescriptions = list(
#'       list(
#'         OutputId = "string",
#'         Name = "string",
#'         KinesisStreamsOutputDescription = list(
#'           ResourceARN = "string",
#'           RoleARN = "string"
#'         ),
#'         KinesisFirehoseOutputDescription = list(
#'           ResourceARN = "string",
#'           RoleARN = "string"
#'         ),
#'         LambdaOutputDescription = list(
#'           ResourceARN = "string",
#'           RoleARN = "string"
#'         ),
#'         DestinationSchema = list(
#'           RecordFormatType = "JSON"|"CSV"
#'         )
#'       )
#'     ),
#'     ReferenceDataSourceDescriptions = list(
#'       list(
#'         ReferenceId = "string",
#'         TableName = "string",
#'         S3ReferenceDataSourceDescription = list(
#'           BucketARN = "string",
#'           FileKey = "string",
#'           ReferenceRoleARN = "string"
#'         ),
#'         ReferenceSchema = list(
#'           RecordFormat = list(
#'             RecordFormatType = "JSON"|"CSV",
#'             MappingParameters = list(
#'               JSONMappingParameters = list(
#'                 RecordRowPath = "string"
#'               ),
#'               CSVMappingParameters = list(
#'                 RecordRowDelimiter = "string",
#'                 RecordColumnDelimiter = "string"
#'               )
#'             )
#'           ),
#'           RecordEncoding = "string",
#'           RecordColumns = list(
#'             list(
#'               Name = "string",
#'               Mapping = "string",
#'               SqlType = "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     CloudWatchLoggingOptionDescriptions = list(
#'       list(
#'         CloudWatchLoggingOptionId = "string",
#'         LogStreamARN = "string",
#'         RoleARN = "string"
#'       )
#'     ),
#'     ApplicationCode = "string",
#'     ApplicationVersionId = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_application(
#'   ApplicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_describe_application
kinesisanalytics_describe_application <- function(ApplicationName) {
  op <- new_operation(
    name = "DescribeApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$describe_application_input(ApplicationName = ApplicationName)
  output <- .kinesisanalytics$describe_application_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$describe_application <- kinesisanalytics_describe_application

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Infers a schema by evaluating sample records on the specified streaming
#' source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery
#' stream) or S3 object. In the response, the operation returns the
#' inferred schema and also the sample records that the operation used to
#' infer the schema.
#' 
#' You can use the inferred schema when configuring a streaming source for
#' your application. For conceptual information, see [Configuring
#' Application
#' Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
#' Note that when you create an application using the Amazon Kinesis
#' Analytics console, the console uses this operation to infer a schema and
#' show it in the console user interface.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:DiscoverInputSchema` action.
#'
#' @usage
#' kinesisanalytics_discover_input_schema(ResourceARN, RoleARN,
#'   InputStartingPositionConfiguration, S3Configuration,
#'   InputProcessingConfiguration)
#'
#' @param ResourceARN Amazon Resource Name (ARN) of the streaming source.
#' @param RoleARN ARN of the IAM role that Amazon Kinesis Analytics can assume to access
#' the stream on your behalf.
#' @param InputStartingPositionConfiguration Point at which you want Amazon Kinesis Analytics to start reading
#' records from the specified streaming source discovery purposes.
#' @param S3Configuration Specify this parameter to discover a schema from data in an Amazon S3
#' object.
#' @param InputProcessingConfiguration The
#' [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
#' to use to preprocess the records before discovering the schema of the
#' records.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InputSchema = list(
#'     RecordFormat = list(
#'       RecordFormatType = "JSON"|"CSV",
#'       MappingParameters = list(
#'         JSONMappingParameters = list(
#'           RecordRowPath = "string"
#'         ),
#'         CSVMappingParameters = list(
#'           RecordRowDelimiter = "string",
#'           RecordColumnDelimiter = "string"
#'         )
#'       )
#'     ),
#'     RecordEncoding = "string",
#'     RecordColumns = list(
#'       list(
#'         Name = "string",
#'         Mapping = "string",
#'         SqlType = "string"
#'       )
#'     )
#'   ),
#'   ParsedInputRecords = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   ProcessedInputRecords = list(
#'     "string"
#'   ),
#'   RawInputRecords = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$discover_input_schema(
#'   ResourceARN = "string",
#'   RoleARN = "string",
#'   InputStartingPositionConfiguration = list(
#'     InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
#'   ),
#'   S3Configuration = list(
#'     RoleARN = "string",
#'     BucketARN = "string",
#'     FileKey = "string"
#'   ),
#'   InputProcessingConfiguration = list(
#'     InputLambdaProcessor = list(
#'       ResourceARN = "string",
#'       RoleARN = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_discover_input_schema
kinesisanalytics_discover_input_schema <- function(ResourceARN = NULL, RoleARN = NULL, InputStartingPositionConfiguration = NULL, S3Configuration = NULL, InputProcessingConfiguration = NULL) {
  op <- new_operation(
    name = "DiscoverInputSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$discover_input_schema_input(ResourceARN = ResourceARN, RoleARN = RoleARN, InputStartingPositionConfiguration = InputStartingPositionConfiguration, S3Configuration = S3Configuration, InputProcessingConfiguration = InputProcessingConfiguration)
  output <- .kinesisanalytics$discover_input_schema_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$discover_input_schema <- kinesisanalytics_discover_input_schema

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Returns a list of Amazon Kinesis Analytics applications in your account.
#' For each application, the response includes the application name, Amazon
#' Resource Name (ARN), and status. If the response returns the
#' `HasMoreApplications` value as true, you can send another request by
#' adding the `ExclusiveStartApplicationName` in the request body, and set
#' the value of this to the last application name from the previous
#' response.
#' 
#' If you want detailed information about a specific application, use
#' [`describe_application`][kinesisanalytics_describe_application].
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:ListApplications` action.
#'
#' @usage
#' kinesisanalytics_list_applications(Limit, ExclusiveStartApplicationName)
#'
#' @param Limit Maximum number of applications to list.
#' @param ExclusiveStartApplicationName Name of the application to start the list with. When using pagination to
#' retrieve the list, you don't need to specify this parameter in the first
#' request. However, in subsequent requests, you add the last application
#' name from the previous response to get the next page of applications.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationSummaries = list(
#'     list(
#'       ApplicationName = "string",
#'       ApplicationARN = "string",
#'       ApplicationStatus = "DELETING"|"STARTING"|"STOPPING"|"READY"|"RUNNING"|"UPDATING"
#'     )
#'   ),
#'   HasMoreApplications = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_applications(
#'   Limit = 123,
#'   ExclusiveStartApplicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_list_applications
kinesisanalytics_list_applications <- function(Limit = NULL, ExclusiveStartApplicationName = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$list_applications_input(Limit = Limit, ExclusiveStartApplicationName = ExclusiveStartApplicationName)
  output <- .kinesisanalytics$list_applications_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$list_applications <- kinesisanalytics_list_applications

#' Retrieves the list of key-value tags assigned to the application
#'
#' @description
#' Retrieves the list of key-value tags assigned to the application. For
#' more information, see [Using
#' Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
#'
#' @usage
#' kinesisanalytics_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the application for which to retrieve tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_list_tags_for_resource
kinesisanalytics_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .kinesisanalytics$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$list_tags_for_resource <- kinesisanalytics_list_tags_for_resource

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Starts the specified Amazon Kinesis Analytics application. After
#' creating an application, you must exclusively call this operation to
#' start your application.
#' 
#' After the application starts, it begins consuming the input data,
#' processes it, and writes the output to the configured destination.
#' 
#' The application status must be `READY` for you to start an application.
#' You can get the application status in the console or using the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation.
#' 
#' After you start the application, you can stop the application from
#' processing the input by calling the
#' [`stop_application`][kinesisanalytics_stop_application] operation.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:StartApplication` action.
#'
#' @usage
#' kinesisanalytics_start_application(ApplicationName, InputConfigurations)
#'
#' @param ApplicationName &#91;required&#93; Name of the application.
#' @param InputConfigurations &#91;required&#93; Identifies the specific input, by ID, that the application starts
#' consuming. Amazon Kinesis Analytics starts reading the streaming source
#' associated with the input. You can also specify where in the streaming
#' source you want Amazon Kinesis Analytics to start reading.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$start_application(
#'   ApplicationName = "string",
#'   InputConfigurations = list(
#'     list(
#'       Id = "string",
#'       InputStartingPositionConfiguration = list(
#'         InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_start_application
kinesisanalytics_start_application <- function(ApplicationName, InputConfigurations) {
  op <- new_operation(
    name = "StartApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$start_application_input(ApplicationName = ApplicationName, InputConfigurations = InputConfigurations)
  output <- .kinesisanalytics$start_application_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$start_application <- kinesisanalytics_start_application

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Stops the application from processing input data. You can stop an
#' application only if it is in the running state. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to find the application state. After the application is
#' stopped, Amazon Kinesis Analytics stops reading data from the input, the
#' application stops processing data, and there is no output written to the
#' destination.
#' 
#' This operation requires permissions to perform the
#' `kinesisanalytics:StopApplication` action.
#'
#' @usage
#' kinesisanalytics_stop_application(ApplicationName)
#'
#' @param ApplicationName &#91;required&#93; Name of the running application to stop.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$stop_application(
#'   ApplicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_stop_application
kinesisanalytics_stop_application <- function(ApplicationName) {
  op <- new_operation(
    name = "StopApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$stop_application_input(ApplicationName = ApplicationName)
  output <- .kinesisanalytics$stop_application_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$stop_application <- kinesisanalytics_stop_application

#' Adds one or more key-value tags to a Kinesis Analytics application
#'
#' @description
#' Adds one or more key-value tags to a Kinesis Analytics application. Note
#' that the maximum number of application tags includes system tags. The
#' maximum number of user-defined application tags is 50. For more
#' information, see [Using
#' Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
#'
#' @usage
#' kinesisanalytics_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the application to assign the tags.
#' @param Tags &#91;required&#93; The key-value tags to assign to the application.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_tag_resource
kinesisanalytics_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .kinesisanalytics$tag_resource_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$tag_resource <- kinesisanalytics_tag_resource

#' Removes one or more tags from a Kinesis Analytics application
#'
#' @description
#' Removes one or more tags from a Kinesis Analytics application. For more
#' information, see [Using
#' Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
#'
#' @usage
#' kinesisanalytics_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Kinesis Analytics application from which to remove the
#' tags.
#' @param TagKeys &#91;required&#93; A list of keys of tags to remove from the specified application.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_untag_resource
kinesisanalytics_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .kinesisanalytics$untag_resource_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$untag_resource <- kinesisanalytics_untag_resource

#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications
#'
#' @description
#' This documentation is for version 1 of the Amazon Kinesis Data Analytics
#' API, which only supports SQL applications. Version 2 of the API supports
#' SQL and Java applications. For more information about version 2, see
#' Amazon Kinesis Data Analytics API V2 Documentation.
#' 
#' Updates an existing Amazon Kinesis Analytics application. Using this
#' API, you can update application code, input configuration, and output
#' configuration.
#' 
#' Note that Amazon Kinesis Analytics updates the
#' `CurrentApplicationVersionId` each time you update your application.
#' 
#' This operation requires permission for the
#' `kinesisanalytics:UpdateApplication` action.
#'
#' @usage
#' kinesisanalytics_update_application(ApplicationName,
#'   CurrentApplicationVersionId, ApplicationUpdate)
#'
#' @param ApplicationName &#91;required&#93; Name of the Amazon Kinesis Analytics application to update.
#' @param CurrentApplicationVersionId &#91;required&#93; The current application version ID. You can use the
#' [`describe_application`][kinesisanalytics_describe_application]
#' operation to get this value.
#' @param ApplicationUpdate &#91;required&#93; Describes application updates.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   ApplicationUpdate = list(
#'     InputUpdates = list(
#'       list(
#'         InputId = "string",
#'         NamePrefixUpdate = "string",
#'         InputProcessingConfigurationUpdate = list(
#'           InputLambdaProcessorUpdate = list(
#'             ResourceARNUpdate = "string",
#'             RoleARNUpdate = "string"
#'           )
#'         ),
#'         KinesisStreamsInputUpdate = list(
#'           ResourceARNUpdate = "string",
#'           RoleARNUpdate = "string"
#'         ),
#'         KinesisFirehoseInputUpdate = list(
#'           ResourceARNUpdate = "string",
#'           RoleARNUpdate = "string"
#'         ),
#'         InputSchemaUpdate = list(
#'           RecordFormatUpdate = list(
#'             RecordFormatType = "JSON"|"CSV",
#'             MappingParameters = list(
#'               JSONMappingParameters = list(
#'                 RecordRowPath = "string"
#'               ),
#'               CSVMappingParameters = list(
#'                 RecordRowDelimiter = "string",
#'                 RecordColumnDelimiter = "string"
#'               )
#'             )
#'           ),
#'           RecordEncodingUpdate = "string",
#'           RecordColumnUpdates = list(
#'             list(
#'               Name = "string",
#'               Mapping = "string",
#'               SqlType = "string"
#'             )
#'           )
#'         ),
#'         InputParallelismUpdate = list(
#'           CountUpdate = 123
#'         )
#'       )
#'     ),
#'     ApplicationCodeUpdate = "string",
#'     OutputUpdates = list(
#'       list(
#'         OutputId = "string",
#'         NameUpdate = "string",
#'         KinesisStreamsOutputUpdate = list(
#'           ResourceARNUpdate = "string",
#'           RoleARNUpdate = "string"
#'         ),
#'         KinesisFirehoseOutputUpdate = list(
#'           ResourceARNUpdate = "string",
#'           RoleARNUpdate = "string"
#'         ),
#'         LambdaOutputUpdate = list(
#'           ResourceARNUpdate = "string",
#'           RoleARNUpdate = "string"
#'         ),
#'         DestinationSchemaUpdate = list(
#'           RecordFormatType = "JSON"|"CSV"
#'         )
#'       )
#'     ),
#'     ReferenceDataSourceUpdates = list(
#'       list(
#'         ReferenceId = "string",
#'         TableNameUpdate = "string",
#'         S3ReferenceDataSourceUpdate = list(
#'           BucketARNUpdate = "string",
#'           FileKeyUpdate = "string",
#'           ReferenceRoleARNUpdate = "string"
#'         ),
#'         ReferenceSchemaUpdate = list(
#'           RecordFormat = list(
#'             RecordFormatType = "JSON"|"CSV",
#'             MappingParameters = list(
#'               JSONMappingParameters = list(
#'                 RecordRowPath = "string"
#'               ),
#'               CSVMappingParameters = list(
#'                 RecordRowDelimiter = "string",
#'                 RecordColumnDelimiter = "string"
#'               )
#'             )
#'           ),
#'           RecordEncoding = "string",
#'           RecordColumns = list(
#'             list(
#'               Name = "string",
#'               Mapping = "string",
#'               SqlType = "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     CloudWatchLoggingOptionUpdates = list(
#'       list(
#'         CloudWatchLoggingOptionId = "string",
#'         LogStreamARNUpdate = "string",
#'         RoleARNUpdate = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalytics_update_application
kinesisanalytics_update_application <- function(ApplicationName, CurrentApplicationVersionId, ApplicationUpdate) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalytics$update_application_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ApplicationUpdate = ApplicationUpdate)
  output <- .kinesisanalytics$update_application_output()
  config <- get_config()
  svc <- .kinesisanalytics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalytics$operations$update_application <- kinesisanalytics_update_application
