% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_update_work_group}
\alias{athena_update_work_group}
\title{Updates the workgroup with the specified name}
\usage{
athena_update_work_group(WorkGroup, Description, ConfigurationUpdates,
  State)
}
\arguments{
\item{WorkGroup}{[required] The specified workgroup that will be updated.}

\item{Description}{The workgroup description.}

\item{ConfigurationUpdates}{The workgroup configuration that will be updated for the given
workgroup.}

\item{State}{The workgroup state that will be updated for the given workgroup.}
}
\description{
Updates the workgroup with the specified name. The workgroup's name
cannot be changed.
}
\section{Request syntax}{
\preformatted{svc$update_work_group(
  WorkGroup = "string",
  Description = "string",
  ConfigurationUpdates = list(
    EnforceWorkGroupConfiguration = TRUE|FALSE,
    ResultConfigurationUpdates = list(
      OutputLocation = "string",
      RemoveOutputLocation = TRUE|FALSE,
      EncryptionConfiguration = list(
        EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
        KmsKey = "string"
      ),
      RemoveEncryptionConfiguration = TRUE|FALSE
    ),
    PublishCloudWatchMetricsEnabled = TRUE|FALSE,
    BytesScannedCutoffPerQuery = 123,
    RemoveBytesScannedCutoffPerQuery = TRUE|FALSE
  ),
  State = "ENABLED"|"DISABLED"
)
}
}

\keyword{internal}
