% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_get_dashboard_embed_url}
\alias{quicksight_get_dashboard_embed_url}
\title{Generates a server-side embeddable URL and authorization code}
\usage{
quicksight_get_dashboard_embed_url(AwsAccountId, DashboardId,
  IdentityType, SessionLifetimeInMinutes, UndoRedoDisabled, ResetDisabled,
  UserArn)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that contains the dashboard that you\'re
embedding.}

\item{DashboardId}{[required] The ID for the dashboard, also added to the IAM policy.}

\item{IdentityType}{[required] The authentication method that the user uses to sign in.}

\item{SessionLifetimeInMinutes}{How many minutes the session is valid. The session lifetime must be
15-600 minutes.}

\item{UndoRedoDisabled}{Remove the undo/redo button on the embedded dashboard. The default is
FALSE, which enables the undo/redo button.}

\item{ResetDisabled}{Remove the reset button on the embedded dashboard. The default is FALSE,
which enables the reset button.}

\item{UserArn}{The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with
\code{QUICKSIGHT} identity type. You can use this for any Amazon QuickSight
users in your account (readers, authors, or admins) authenticated as one
of the following:
\itemize{
\item Active Directory (AD) users or group members
\item Invited nonfederated users
\item IAM users and IAM role-based sessions authenticated through
Federated Single Sign-On using SAML, OpenID Connect, or IAM
federation.
}}
}
\description{
Generates a server-side embeddable URL and authorization code. For this
process to work properly, first configure the dashboards and user
permissions. For more information, see \href{https://docs.aws.amazon.com/quicksight/latest/user/embedding-dashboards.html}{Embedding Amazon QuickSight Dashboards}
in the \emph{Amazon QuickSight User Guide} or \href{https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-dev-embedded-dashboards.html}{Embedding Amazon QuickSight Dashboards}
in the \emph{Amazon QuickSight API Reference}.
}
\details{
Currently, you can use \code{GetDashboardEmbedURL} only from the server, not
from the user's browser.
}
\section{Request syntax}{
\preformatted{svc$get_dashboard_embed_url(
  AwsAccountId = "string",
  DashboardId = "string",
  IdentityType = "IAM"|"QUICKSIGHT",
  SessionLifetimeInMinutes = 123,
  UndoRedoDisabled = TRUE|FALSE,
  ResetDisabled = TRUE|FALSE,
  UserArn = "string"
)
}
}

\keyword{internal}
