% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_list_tags_for_delivery_stream}
\alias{firehose_list_tags_for_delivery_stream}
\title{Lists the tags for the specified delivery stream}
\usage{
firehose_list_tags_for_delivery_stream(
  DeliveryStreamName,
  ExclusiveStartTagKey = NULL,
  Limit = NULL
)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream whose tags you want to list.}

\item{ExclusiveStartTagKey}{The key to use as the starting point for the list of tags. If you set
this parameter,
\code{\link[=firehose_list_tags_for_delivery_stream]{list_tags_for_delivery_stream}}
gets all tags that occur after \code{ExclusiveStartTagKey}.}

\item{Limit}{The number of tags to return. If this number is less than the total
number of tags associated with the delivery stream, \code{HasMoreTags} is set
to \code{true} in the response. To list additional tags, set
\code{ExclusiveStartTagKey} to the last key in the response.}
}
\description{
Lists the tags for the specified delivery stream. This operation has a limit of five transactions per second per account.

See \url{https://paws-r.github.io/docs/firehose/list_tags_for_delivery_stream.html} for full documentation.
}
\keyword{internal}
