% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_update_monitoring}
\alias{kafka_update_monitoring}
\title{Updates the monitoring settings for the cluster}
\usage{
kafka_update_monitoring(
  ClusterArn,
  CurrentVersion,
  EnhancedMonitoring = NULL,
  OpenMonitoring = NULL,
  LoggingInfo = NULL
)
}
\arguments{
\item{ClusterArn}{[required] The Amazon Resource Name (ARN) that uniquely identifies the cluster.}

\item{CurrentVersion}{[required] The version of the MSK cluster to update. Cluster versions aren't simple
numbers. You can describe an MSK cluster to find its version. When this
update operation is successful, it generates a new cluster version.}

\item{EnhancedMonitoring}{Specifies which Apache Kafka metrics Amazon MSK gathers and sends to
Amazon CloudWatch for this cluster.}

\item{OpenMonitoring}{The settings for open monitoring.}

\item{LoggingInfo}{}
}
\description{
Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.

See \url{https://paws-r.github.io/docs/kafka/update_monitoring.html} for full documentation.
}
\keyword{internal}
