% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_create_domain}
\alias{opensearchservice_create_domain}
\title{Creates a new Amazon OpenSearch Service domain}
\usage{
opensearchservice_create_domain(
  DomainName,
  EngineVersion = NULL,
  ClusterConfig = NULL,
  EBSOptions = NULL,
  AccessPolicies = NULL,
  SnapshotOptions = NULL,
  VPCOptions = NULL,
  CognitoOptions = NULL,
  EncryptionAtRestOptions = NULL,
  NodeToNodeEncryptionOptions = NULL,
  AdvancedOptions = NULL,
  LogPublishingOptions = NULL,
  DomainEndpointOptions = NULL,
  AdvancedSecurityOptions = NULL,
  TagList = NULL,
  AutoTuneOptions = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the Amazon OpenSearch Service domain you're creating. Domain
names are unique across the domains owned by an account within an AWS
region. Domain names must start with a lowercase letter and can contain
the following characters: a-z (lowercase), 0-9, and - (hyphen).}

\item{EngineVersion}{String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the
engine version for the Amazon OpenSearch Service domain. For example,
"OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains"
target="_blank">Creating and managing Amazon OpenSearch Service
domains</a> .}

\item{ClusterConfig}{Configuration options for a domain. Specifies the instance type and
number of instances in the domain.}

\item{EBSOptions}{Options to enable, disable, and specify the type and size of EBS storage
volumes.}

\item{AccessPolicies}{IAM access policy as a JSON-formatted string.}

\item{SnapshotOptions}{Option to set time, in UTC format, of the daily automated snapshot.
Default value is 0 hours.}

\item{VPCOptions}{Options to specify the subnets and security groups for a VPC endpoint.
For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
target="_blank">Launching your Amazon OpenSearch Service domains using a
VPC</a> .}

\item{CognitoOptions}{Options to specify the Cognito user and identity pools for OpenSearch
Dashboards authentication. For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
target="_blank">Configuring Amazon Cognito authentication for OpenSearch
Dashboards</a>.}

\item{EncryptionAtRestOptions}{Options for encryption of data at rest.}

\item{NodeToNodeEncryptionOptions}{Node-to-node encryption options.}

\item{AdvancedOptions}{Option to allow references to indices in an HTTP request body. Must be
\code{false} when configuring access to individual sub-resources. By default,
the value is \code{true}. See <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
target="_blank">Advanced cluster parameters</a> for more information.}

\item{LogPublishingOptions}{Map of \code{LogType} and \code{LogPublishingOption}, each containing options to
publish a given type of OpenSearch log.}

\item{DomainEndpointOptions}{Options to specify configurations that will be applied to the domain
endpoint.}

\item{AdvancedSecurityOptions}{Specifies advanced security options.}

\item{TagList}{A list of \code{Tag} added during domain creation.}

\item{AutoTuneOptions}{Specifies Auto-Tune options.}
}
\description{
Creates a new Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html" target="_blank">Creating and managing Amazon OpenSearch Service domains</a> in the \emph{Amazon OpenSearch Service Developer Guide}.

See \url{https://paws-r.github.io/docs/opensearchservice/create_domain.html} for full documentation.
}
\keyword{internal}
