% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_analysis_permissions}
\alias{quicksight_update_analysis_permissions}
\title{Updates the read and write permissions for an analysis}
\usage{
quicksight_update_analysis_permissions(
  AwsAccountId,
  AnalysisId,
  GrantPermissions = NULL,
  RevokePermissions = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account that contains the analysis
whose permissions you're updating. You must be using the Amazon Web
Services account that the analysis is in.}

\item{AnalysisId}{[required] The ID of the analysis whose permissions you're updating. The ID is part
of the analysis URL.}

\item{GrantPermissions}{A structure that describes the permissions to add and the principal to
add them to.}

\item{RevokePermissions}{A structure that describes the permissions to remove and the principal
to remove them from.}
}
\description{
Updates the read and write permissions for an analysis.

See \url{https://paws-r.github.io/docs/quicksight/update_analysis_permissions.html} for full documentation.
}
\keyword{internal}
