% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_schema}
\alias{glue_update_schema}
\title{Updates the description, compatibility setting, or version checkpoint
for a schema set}
\usage{
glue_update_schema(
  SchemaId,
  SchemaVersionNumber = NULL,
  Compatibility = NULL,
  Description = NULL
)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure to contain schema identity fields. The
structure contains:
\itemize{
\item SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
One of \code{SchemaArn} or \code{SchemaName} has to be provided.
\item SchemaId$SchemaName: The name of the schema. One of \code{SchemaArn} or
\code{SchemaName} has to be provided.
}}

\item{SchemaVersionNumber}{Version number required for check pointing. One of \code{VersionNumber} or
\code{Compatibility} has to be provided.}

\item{Compatibility}{The new compatibility setting for the schema.}

\item{Description}{The new description for the schema.}
}
\description{
Updates the description, compatibility setting, or version checkpoint for a schema set.

See \url{https://www.paws-r-sdk.com/docs/glue_update_schema/} for full documentation.
}
\keyword{internal}
