# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' OpenSearch Service Serverless
#'
#' @description
#' Use the Amazon OpenSearch Serverless API to create, configure, and
#' manage OpenSearch Serverless collections and security policies.
#' 
#' OpenSearch Serverless is an on-demand, pre-provisioned serverless
#' configuration for Amazon OpenSearch Service. OpenSearch Serverless
#' removes the operational complexities of provisioning, configuring, and
#' tuning your OpenSearch clusters. It enables you to easily search and
#' analyze petabytes of data without having to worry about the underlying
#' infrastructure and data management.
#' 
#' To learn more about OpenSearch Serverless, see [What is Amazon
#' OpenSearch
#' Serverless?](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- opensearchserviceserverless(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- opensearchserviceserverless()
#' svc$batch_get_collection(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=opensearchserviceserverless_batch_get_collection]{batch_get_collection} \tab Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint\cr
#'  \link[=opensearchserviceserverless_batch_get_effective_lifecycle_policy]{batch_get_effective_lifecycle_policy} \tab Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes\cr
#'  \link[=opensearchserviceserverless_batch_get_lifecycle_policy]{batch_get_lifecycle_policy} \tab Returns one or more configured OpenSearch Serverless lifecycle policies\cr
#'  \link[=opensearchserviceserverless_batch_get_vpc_endpoint]{batch_get_vpc_endpoint} \tab Returns attributes for one or more VPC endpoints associated with the current account\cr
#'  \link[=opensearchserviceserverless_create_access_policy]{create_access_policy} \tab Creates a data access policy for OpenSearch Serverless\cr
#'  \link[=opensearchserviceserverless_create_collection]{create_collection} \tab Creates a new OpenSearch Serverless collection\cr
#'  \link[=opensearchserviceserverless_create_lifecycle_policy]{create_lifecycle_policy} \tab Creates a lifecyle policy to be applied to OpenSearch Serverless indexes\cr
#'  \link[=opensearchserviceserverless_create_security_config]{create_security_config} \tab Specifies a security configuration for OpenSearch Serverless\cr
#'  \link[=opensearchserviceserverless_create_security_policy]{create_security_policy} \tab Creates a security policy to be used by one or more OpenSearch Serverless collections\cr
#'  \link[=opensearchserviceserverless_create_vpc_endpoint]{create_vpc_endpoint} \tab Creates an OpenSearch Serverless-managed interface VPC endpoint\cr
#'  \link[=opensearchserviceserverless_delete_access_policy]{delete_access_policy} \tab Deletes an OpenSearch Serverless access policy\cr
#'  \link[=opensearchserviceserverless_delete_collection]{delete_collection} \tab Deletes an OpenSearch Serverless collection\cr
#'  \link[=opensearchserviceserverless_delete_lifecycle_policy]{delete_lifecycle_policy} \tab Deletes an OpenSearch Serverless lifecycle policy\cr
#'  \link[=opensearchserviceserverless_delete_security_config]{delete_security_config} \tab Deletes a security configuration for OpenSearch Serverless\cr
#'  \link[=opensearchserviceserverless_delete_security_policy]{delete_security_policy} \tab Deletes an OpenSearch Serverless security policy\cr
#'  \link[=opensearchserviceserverless_delete_vpc_endpoint]{delete_vpc_endpoint} \tab Deletes an OpenSearch Serverless-managed interface endpoint\cr
#'  \link[=opensearchserviceserverless_get_access_policy]{get_access_policy} \tab Returns an OpenSearch Serverless access policy\cr
#'  \link[=opensearchserviceserverless_get_account_settings]{get_account_settings} \tab Returns account-level settings related to OpenSearch Serverless\cr
#'  \link[=opensearchserviceserverless_get_policies_stats]{get_policies_stats} \tab Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies\cr
#'  \link[=opensearchserviceserverless_get_security_config]{get_security_config} \tab Returns information about an OpenSearch Serverless security configuration\cr
#'  \link[=opensearchserviceserverless_get_security_policy]{get_security_policy} \tab Returns information about a configured OpenSearch Serverless security policy\cr
#'  \link[=opensearchserviceserverless_list_access_policies]{list_access_policies} \tab Returns information about a list of OpenSearch Serverless access policies\cr
#'  \link[=opensearchserviceserverless_list_collections]{list_collections} \tab Lists all OpenSearch Serverless collections\cr
#'  \link[=opensearchserviceserverless_list_lifecycle_policies]{list_lifecycle_policies} \tab Returns a list of OpenSearch Serverless lifecycle policies\cr
#'  \link[=opensearchserviceserverless_list_security_configs]{list_security_configs} \tab Returns information about configured OpenSearch Serverless security configurations\cr
#'  \link[=opensearchserviceserverless_list_security_policies]{list_security_policies} \tab Returns information about configured OpenSearch Serverless security policies\cr
#'  \link[=opensearchserviceserverless_list_tags_for_resource]{list_tags_for_resource} \tab Returns the tags for an OpenSearch Serverless resource\cr
#'  \link[=opensearchserviceserverless_list_vpc_endpoints]{list_vpc_endpoints} \tab Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account\cr
#'  \link[=opensearchserviceserverless_tag_resource]{tag_resource} \tab Associates tags with an OpenSearch Serverless resource\cr
#'  \link[=opensearchserviceserverless_untag_resource]{untag_resource} \tab Removes a tag or set of tags from an OpenSearch Serverless resource\cr
#'  \link[=opensearchserviceserverless_update_access_policy]{update_access_policy} \tab Updates an OpenSearch Serverless access policy\cr
#'  \link[=opensearchserviceserverless_update_account_settings]{update_account_settings} \tab Update the OpenSearch Serverless settings for the current Amazon Web Services account\cr
#'  \link[=opensearchserviceserverless_update_collection]{update_collection} \tab Updates an OpenSearch Serverless collection\cr
#'  \link[=opensearchserviceserverless_update_lifecycle_policy]{update_lifecycle_policy} \tab Updates an OpenSearch Serverless access policy\cr
#'  \link[=opensearchserviceserverless_update_security_config]{update_security_config} \tab Updates a security configuration for OpenSearch Serverless\cr
#'  \link[=opensearchserviceserverless_update_security_policy]{update_security_policy} \tab Updates an OpenSearch Serverless security policy\cr
#'  \link[=opensearchserviceserverless_update_vpc_endpoint]{update_vpc_endpoint} \tab Updates an OpenSearch Serverless-managed interface endpoint
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname opensearchserviceserverless
#' @export
opensearchserviceserverless <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .opensearchserviceserverless$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.opensearchserviceserverless <- list()

.opensearchserviceserverless$operations <- list()

.opensearchserviceserverless$metadata <- list(
  service_name = "opensearchserviceserverless",
  endpoints = list("*" = list(endpoint = "aoss.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "aoss.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "aoss.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "aoss.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "aoss.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "aoss.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "OpenSearchServerless",
  api_version = "2021-11-01",
  signing_name = "aoss",
  json_version = "1.0",
  target_prefix = "OpenSearchServerless"
)

.opensearchserviceserverless$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.opensearchserviceserverless$metadata, handlers, config, op)
}
