% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_start_asset_bundle_export_job}
\alias{quicksight_start_asset_bundle_export_job}
\title{Starts an Asset Bundle export job}
\usage{
quicksight_start_asset_bundle_export_job(
  AwsAccountId,
  AssetBundleExportJobId,
  ResourceArns,
  IncludeAllDependencies = NULL,
  ExportFormat,
  CloudFormationOverridePropertyConfiguration = NULL,
  IncludePermissions = NULL,
  IncludeTags = NULL,
  ValidationStrategy = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account to export assets from.}

\item{AssetBundleExportJobId}{[required] The ID of the job. This ID is unique while the job is running. After the
job is completed, you can reuse this ID for another job.}

\item{ResourceArns}{[required] An array of resource ARNs to export. The following resources are
supported.
\itemize{
\item \code{Analysis}
\item \code{Dashboard}
\item \code{DataSet}
\item \code{DataSource}
\item \code{RefreshSchedule}
\item \code{Theme}
\item \code{VPCConnection}
}

The API caller must have the necessary permissions in their IAM role to
access each resource before the resources can be exported.}

\item{IncludeAllDependencies}{A Boolean that determines whether all dependencies of each resource ARN
are recursively exported with the job. For example, say you provided a
Dashboard ARN to the \code{ResourceArns} parameter. If you set
\code{IncludeAllDependencies} to \code{TRUE}, any theme, dataset, and data source
resource that is a dependency of the dashboard is also exported.}

\item{ExportFormat}{[required] The export data format.}

\item{CloudFormationOverridePropertyConfiguration}{An optional collection of structures that generate CloudFormation
parameters to override the existing resource property values when the
resource is exported to a new CloudFormation template.

Use this field if the \code{ExportFormat} field of a
\code{StartAssetBundleExportJobRequest} API call is set to
\code{CLOUDFORMATION_JSON}.}

\item{IncludePermissions}{A Boolean that determines whether all permissions for each resource ARN
are exported with the job. If you set \code{IncludePermissions} to \code{TRUE},
any permissions associated with each resource are exported.}

\item{IncludeTags}{A Boolean that determines whether all tags for each resource ARN are
exported with the job. If you set \code{IncludeTags} to \code{TRUE}, any tags
associated with each resource are exported.}

\item{ValidationStrategy}{An optional parameter that determines which validation strategy to use
for the export job. If \code{StrictModeForAllResources} is set to \code{TRUE},
strict validation for every error is enforced. If it is set to \code{FALSE},
validation is skipped for specific UI errors that are shown as warnings.
The default value for \code{StrictModeForAllResources} is \code{FALSE}.}
}
\description{
Starts an Asset Bundle export job.

See \url{https://www.paws-r-sdk.com/docs/quicksight_start_asset_bundle_export_job/} for full documentation.
}
\keyword{internal}
