% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_image_attribute}
\alias{ec2_describe_image_attribute}
\title{Describes the specified attribute of the specified AMI}
\usage{
ec2_describe_image_attribute(Attribute, ImageId, DryRun)
}
\arguments{
\item{Attribute}{[required] The AMI attribute.

\strong{Note}: Depending on your account privileges, the \code{blockDeviceMapping}
attribute may return a \code{Client.AuthFailure} error. If this happens, use
DescribeImages to get information about the block device mapping for the
AMI.}

\item{ImageId}{[required] The ID of the AMI.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified attribute of the specified AMI. You can specify
only one attribute at a time.
}
\section{Request syntax}{
\preformatted{svc$describe_image_attribute(
  Attribute = "description"|"kernel"|"ramdisk"|"launchPermission"|"productCodes"|"blockDeviceMapping"|"sriovNetSupport",
  ImageId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example describes the launch permissions for the specified AMI.
\donttest{svc$describe_image_attribute(
  Attribute = "launchPermission",
  ImageId = "ami-5731123e"
)}

}
\keyword{internal}
