% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_function_configuration}
\alias{lambda_update_function_configuration}
\title{Modify the version-specifc settings of a Lambda function}
\usage{
lambda_update_function_configuration(FunctionName, Role, Handler,
  Description, Timeout, MemorySize, VpcConfig, Environment, Runtime,
  DeadLetterConfig, KMSKeyArn, TracingConfig, RevisionId, Layers)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{my-function}.
\item \strong{Function ARN} -
\code{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \code{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Role}{The Amazon Resource Name (ARN) of the function's execution role.}

\item{Handler}{The name of the method within your code that Lambda calls to execute
your function. The format includes the file name. It can also include
namespaces and other qualifiers, depending on the runtime. For more
information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html}{Programming Model}.}

\item{Description}{A description of the function.}

\item{Timeout}{The amount of time that Lambda allows a function to run before stopping
it. The default is 3 seconds. The maximum allowed value is 900 seconds.}

\item{MemorySize}{The amount of memory that your function has access to. Increasing the
function's memory also increases its CPU allocation. The default value
is 128 MB. The value must be a multiple of 64 MB.}

\item{VpcConfig}{For network connectivity to AWS resources in a VPC, specify a list of
security groups and subnets in the VPC. When you connect a function to a
VPC, it can only access resources and the internet through that VPC. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/vpc.html}{VPC Settings}.}

\item{Environment}{Environment variables that are accessible from function code during
execution.}

\item{Runtime}{The identifier of the function's
\href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{runtime}.}

\item{DeadLetterConfig}{A dead letter queue configuration that specifies the queue or topic
where Lambda sends asynchronous events when they fail processing. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/dlq.html}{Dead Letter Queues}.}

\item{KMSKeyArn}{The ARN of the AWS Key Management Service (AWS KMS) key that's used to
encrypt your function's environment variables. If it's not provided,
AWS Lambda uses a default service key.}

\item{TracingConfig}{Set \code{Mode} to \code{Active} to sample and trace a subset of incoming requests
with AWS X-Ray.}

\item{RevisionId}{Only update the function if the revision ID matches the ID that's
specified. Use this option to avoid modifying a function that has
changed since you last read it.}

\item{Layers}{A list of \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{function layers}
to add to the function's execution environment. Specify each layer by
its ARN, including the version.}
}
\description{
Modify the version-specifc settings of a Lambda function.
}
\details{
These settings can vary between versions of a function and are locked
when you publish a version. You can't modify the configuration of a
published version, only the unpublished version.

To configure function concurrency, use PutFunctionConcurrency. To grant
invoke permissions to an account or AWS service, use AddPermission.
}
\section{Request syntax}{
\preformatted{svc$update_function_configuration(
  FunctionName = "string",
  Role = "string",
  Handler = "string",
  Description = "string",
  Timeout = 123,
  MemorySize = 123,
  VpcConfig = list(
    SubnetIds = list(
      "string"
    ),
    SecurityGroupIds = list(
      "string"
    )
  ),
  Environment = list(
    Variables = list(
      "string"
    )
  ),
  Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided",
  DeadLetterConfig = list(
    TargetArn = "string"
  ),
  KMSKeyArn = "string",
  TracingConfig = list(
    Mode = "Active"|"PassThrough"
  ),
  RevisionId = "string",
  Layers = list(
    "string"
  )
)
}
}

\examples{
# This operation updates a Lambda function's configuration
\donttest{svc$update_function_configuration(
  Description = "",
  FunctionName = "myFunction",
  Handler = "index.handler",
  MemorySize = 128L,
  Role = "arn:aws:iam::123456789012:role/lambda_basic_execution",
  Runtime = "python2.7",
  Timeout = 123L,
  VpcConfig = structure(
    list(),
    .Names = character(
      0
    )
  )
)}

}
\keyword{internal}
