% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_address}
\alias{ec2_allocate_address}
\title{Allocates an Elastic IP address to your AWS account}
\usage{
ec2_allocate_address(Domain, Address, PublicIpv4Pool,
  NetworkBorderGroup, CustomerOwnedIpv4Pool, DryRun, TagSpecifications)
}
\arguments{
\item{Domain}{Indicates whether the Elastic IP address is for use with instances in a
VPC or instances in EC2-Classic.

Default: If the Region supports EC2-Classic, the default is \code{standard}.
Otherwise, the default is \code{vpc}.}

\item{Address}{[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an
address pool.}

\item{PublicIpv4Pool}{The ID of an address pool that you own. Use this parameter to let Amazon
EC2 select an address from the address pool. To specify a specific
address from the address pool, use the \code{Address} parameter instead.}

\item{NetworkBorderGroup}{A unique set of Availability Zones, Local Zones, or Wavelength Zones
from which AWS advertises IP addresses. Use this parameter to limit the
IP address to this location. IP addresses cannot move between network
border groups.

Use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html}{DescribeAvailabilityZones}
to view the network border groups.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 classic, you will receive an
\code{InvalidParameterCombination} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.}

\item{CustomerOwnedIpv4Pool}{The ID of a customer-owned address pool. Use this parameter to let
Amazon EC2 select an address from the address pool. Alternatively,
specify a specific address from the address pool.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to assign to the Elastic IP address.}
}
\description{
Allocates an Elastic IP address to your AWS account. After you allocate
the Elastic IP address you can associate it with an instance or network
interface. After you release an Elastic IP address, it is released to
the IP address pool and can be allocated to a different AWS account.

You can allocate an Elastic IP address from an address pool owned by AWS
or from an address pool created from a public IPv4 address range that
you have brought to AWS for use with your AWS resources using bring your
own IP addresses (BYOIP). For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html}{Bring Your Own IP Addresses (BYOIP)}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

[EC2-VPC] If you release an Elastic IP address, you might be able to
recover it. You cannot recover an Elastic IP address that you released
after it is allocated to another AWS account. You cannot recover an
Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP
address that you released, specify it in this operation.

An Elastic IP address is for use either in the EC2-Classic platform or
in a VPC. By default, you can allocate 5 Elastic IP addresses for
EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
Region.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

You can allocate a carrier IP address which is a public IP address from
a telecommunication carrier, to a network interface which resides in a
subnet in a Wavelength Zone (for example an EC2 instance).
}
\section{Request syntax}{
\preformatted{svc$allocate_address(
  Domain = "vpc"|"standard",
  Address = "string",
  PublicIpv4Pool = "string",
  NetworkBorderGroup = "string",
  CustomerOwnedIpv4Pool = "string",
  DryRun = TRUE|FALSE,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example allocates an Elastic IP address to use with an instance in
# a VPC.
svc$allocate_address(
  Domain = "vpc"
)

# This example allocates an Elastic IP address to use with an instance in
# EC2-Classic.
svc$allocate_address()
}

}
\keyword{internal}
