% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_placement}
\alias{ec2_modify_instance_placement}
\title{Modifies the placement attributes for a specified instance}
\usage{
ec2_modify_instance_placement(Affinity, GroupName, HostId, InstanceId,
  Tenancy, PartitionNumber, HostResourceGroupArn)
}
\arguments{
\item{Affinity}{The affinity setting for the instance.}

\item{GroupName}{The name of the placement group in which to place the instance. For
spread placement groups, the instance must have a tenancy of \code{default}.
For cluster and partition placement groups, the instance must have a
tenancy of \code{default} or \code{dedicated}.

To remove an instance from a placement group, specify an empty string
("").}

\item{HostId}{The ID of the Dedicated Host with which to associate the instance.}

\item{InstanceId}{[required] The ID of the instance that you are modifying.}

\item{Tenancy}{The tenancy for the instance.}

\item{PartitionNumber}{Reserved for future use.}

\item{HostResourceGroupArn}{The ARN of the host resource group in which to place the instance.}
}
\description{
Modifies the placement attributes for a specified instance. You can do
the following:
\itemize{
\item Modify the affinity between an instance and a \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html}{Dedicated Host}.
When affinity is set to \code{host} and the instance is not associated
with a specific Dedicated Host, the next time the instance is
launched, it is automatically associated with the host on which it
lands. If the instance is restarted or rebooted, this relationship
persists.
\item Change the Dedicated Host with which an instance is associated.
\item Change the instance tenancy of an instance from \code{host} to
\code{dedicated}, or from \code{dedicated} to \code{host}.
\item Move an instance to or from a \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{placement group}.
}

At least one attribute for affinity, host ID, tenancy, or placement
group name must be specified in the request. Affinity and tenancy can be
modified in the same request.

To modify the host ID, tenancy, placement group, or partition for an
instance, the instance must be in the \code{stopped} state.
}
\section{Request syntax}{
\preformatted{svc$modify_instance_placement(
  Affinity = "default"|"host",
  GroupName = "string",
  HostId = "string",
  InstanceId = "string",
  Tenancy = "dedicated"|"host",
  PartitionNumber = 123,
  HostResourceGroupArn = "string"
)
}
}

\keyword{internal}
