% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_start_instances}
\alias{ec2_start_instances}
\title{Starts an Amazon EBS-backed instance that you've previously stopped}
\usage{
ec2_start_instances(InstanceIds, AdditionalInfo, DryRun)
}
\arguments{
\item{InstanceIds}{[required] The IDs of the instances.}

\item{AdditionalInfo}{Reserved.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Starts an Amazon EBS-backed instance that you've previously stopped.

Instances that use Amazon EBS volumes as their root devices can be
quickly stopped and started. When an instance is stopped, the compute
resources are released and you are not billed for instance usage.
However, your root partition Amazon EBS volume remains and continues to
persist your data, and you are charged for Amazon EBS volume usage. You
can restart your instance at any time. Every time you start your Windows
instance, Amazon EC2 charges you for a full instance hour. If you stop
and restart your Windows instance, a new instance hour begins and Amazon
EC2 charges you for another full instance hour even if you are still
within the same 60-minute period when it was stopped. Every time you
start your Linux instance, Amazon EC2 charges a one-minute minimum for
instance usage, and thereafter charges per second for instance usage.

Before stopping an instance, make sure it is in a state from which it
can be restarted. Stopping an instance does not preserve data stored in
RAM.

Performing this operation on an instance that uses an instance store as
its root device returns an error.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html}{Stopping instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_instances(
  InstanceIds = list(
    "string"
  ),
  AdditionalInfo = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example starts the specified EC2 instance.
svc$start_instances(
  InstanceIds = list(
    "i-1234567890abcdef0"
  )
)
}

}
\keyword{internal}
