% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_complete_layer_upload}
\alias{ecr_complete_layer_upload}
\title{Informs Amazon ECR that the image layer upload has completed for a
specified registry, repository name, and upload ID}
\usage{
ecr_complete_layer_upload(registryId, repositoryName, uploadId,
  layerDigests)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry to which to upload
layers. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The name of the repository to associate with the image layer.}

\item{uploadId}{[required] The upload ID from a previous InitiateLayerUpload operation to associate
with the image layer.}

\item{layerDigests}{[required] The \code{sha256} digest of the image layer.}
}
\description{
Informs Amazon ECR that the image layer upload has completed for a
specified registry, repository name, and upload ID. You can optionally
provide a \code{sha256} digest of the image layer for data validation
purposes.

When an image is pushed, the CompleteLayerUpload API is called once per
each new image layer to verify that the upload has completed.

This operation is used by the Amazon ECR proxy and is not generally used
by customers for pulling and pushing images. In most cases, you should
use the \code{docker} CLI to pull, tag, and push images.
}
\section{Request syntax}{
\preformatted{svc$complete_layer_upload(
  registryId = "string",
  repositoryName = "string",
  uploadId = "string",
  layerDigests = list(
    "string"
  )
)
}
}

\keyword{internal}
