% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_capacity_provider}
\alias{ecs_create_capacity_provider}
\title{Creates a new capacity provider}
\usage{
ecs_create_capacity_provider(name, autoScalingGroupProvider, tags)
}
\arguments{
\item{name}{[required] The name of the capacity provider. Up to 255 characters are allowed,
including letters (upper and lowercase), numbers, underscores, and
hyphens. The name cannot be prefixed with "\code{aws}", "\code{ecs}", or
"\code{fargate}".}

\item{autoScalingGroupProvider}{[required] The details of the Auto Scaling group for the capacity provider.}

\item{tags}{The metadata that you apply to the capacity provider to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . \\_ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}}
}
\description{
Creates a new capacity provider. Capacity providers are associated with
an Amazon ECS cluster and are used in capacity provider strategies to
facilitate cluster auto scaling.

Only capacity providers using an Auto Scaling group can be created.
Amazon ECS tasks on AWS Fargate use the \code{FARGATE} and \code{FARGATE_SPOT}
capacity providers which are already created and available to all
accounts in Regions supported by AWS Fargate.
}
\section{Request syntax}{
\preformatted{svc$create_capacity_provider(
  name = "string",
  autoScalingGroupProvider = list(
    autoScalingGroupArn = "string",
    managedScaling = list(
      status = "ENABLED"|"DISABLED",
      targetCapacity = 123,
      minimumScalingStepSize = 123,
      maximumScalingStepSize = 123,
      instanceWarmupPeriod = 123
    ),
    managedTerminationProtection = "ENABLED"|"DISABLED"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
